/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Type;
import java.beans.PropertyVetoException;
import java.util.Iterator;
import java.util.LinkedList;

public class CompositionType
extends Type {
    Cardinality cardinality = new Cardinality(0L, Long.MAX_VALUE);
    Table componentType;
    boolean ordered = false;
    private LinkedList restrictedTo = new LinkedList();

    public boolean isMandatory() {
        return this.cardinality.getMinimum() != 0L;
    }

    public void setMandatory(boolean mand) {
        if (mand) {
            if (this.cardinality.getMinimum() == 0L) {
                this.cardinality.setMinimum(1L);
            }
        } else if (this.cardinality.getMinimum() > 0L) {
            this.cardinality.setMinimum(0L);
        }
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(Cardinality cardinality) throws PropertyVetoException {
        Cardinality oldValue = this.cardinality;
        Cardinality newValue = cardinality;
        if (newValue == null) {
            throw new IllegalArgumentException();
        }
        if (newValue.equals(oldValue)) {
            return;
        }
        this.fireVetoableChange("cardinality", oldValue, newValue);
        this.cardinality = newValue;
        this.firePropertyChange("cardinality", oldValue, newValue);
    }

    public Table getComponentType() {
        return this.componentType;
    }

    public void setComponentType(Table componentType) throws PropertyVetoException {
        Table oldValue = this.componentType;
        Table newValue = componentType;
        if (newValue == null) {
            throw new IllegalArgumentException(Element.rsrc.getString("err_nullNotAcceptable"));
        }
        if (oldValue == newValue) {
            return;
        }
        if (newValue != null) {
            Iterator iter = newValue.getAttributes();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof AttributeDef)) continue;
                Type attrDomain = ((AttributeDef)obj).getDomain();
                if (attrDomain != null) {
                    attrDomain = attrDomain.resolveAliases();
                }
                if (!(attrDomain instanceof AreaType)) continue;
                throw new IllegalArgumentException(Element.formatMessage("err_compositionType_areaAttr", newValue.toString(), obj.toString()));
            }
        }
        this.fireVetoableChange("componentType", oldValue, newValue);
        if (oldValue != null) {
            oldValue.componentFor.remove(this);
        }
        if (newValue != null) {
            newValue.componentFor.add(this);
        }
        this.componentType = newValue;
        this.firePropertyChange("componentType", oldValue, newValue);
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) throws PropertyVetoException {
        boolean oldValue = this.ordered;
        boolean newValue = ordered;
        if (oldValue == newValue) {
            return;
        }
        this.fireVetoableChange("ordered", oldValue, newValue);
        this.ordered = newValue;
        this.firePropertyChange("ordered", oldValue, newValue);
    }

    void checkTypeExtension(Type wantToExtend) {
        super.checkTypeExtension(wantToExtend);
        if (wantToExtend == null || (wantToExtend = wantToExtend.resolveAliases()) == null) {
            return;
        }
        if (!(wantToExtend instanceof CompositionType)) {
            throw new IllegalArgumentException(Element.rsrc.getString("err_compositionType_ExtOther"));
        }
        CompositionType general = (CompositionType)wantToExtend;
        Table myComponent = this.getComponentType();
        Table generalComponent = general.getComponentType();
        if (this.cardinality.getMaximum() > 1L && !this.isOrdered() && general.isOrdered()) {
            throw new IllegalArgumentException(Element.rsrc.getString("err_compositionType_UnorderedExtOrdered"));
        }
        if (myComponent != null && generalComponent != null && !myComponent.isExtending(generalComponent)) {
            throw new IllegalArgumentException(Element.formatMessage("err_compositionType_componentNotExt", myComponent.toString(), generalComponent.toString()));
        }
        if (!general.cardinality.isGeneralizing(this.cardinality)) {
            throw new IllegalArgumentException(Element.formatMessage("err_compositionType_cardExtMismatch", this.cardinality.toString(), general.cardinality.toString()));
        }
    }

    public void addRestrictedTo(Table structure) {
        this.restrictedTo.add(structure);
        if (!structure.isExtending(this.componentType)) {
            throw new IllegalArgumentException(Element.formatMessage("err_compositionType_restriction", structure.toString(), this.componentType.toString()));
        }
    }

    public Iterator iteratorRestrictedTo() {
        return this.restrictedTo.iterator();
    }
}

