/**
 * D header file for C99.
 *
 * Copyright: Public Domain
 * License:   Public Domain
 * Authors:   Sean Kelly
 * Standards: ISO/IEC 9899:1999 (E)
 */
module stdc.errno;

private
{
    extern (C) int getErrno();
    extern (C) int setErrno(int);
}

int errno()          { return getErrno();      }
int errno( int val ) { return setErrno( val ); }

extern (C):

version( Windows )
{
    const EPERM             = 1;        // Operation not permitted
    const ENOENT            = 2;        // No such file or directory
    const ESRCH             = 3;        // No such process
    const EINTR             = 4;        // Interrupted system call
    const EIO               = 5;        // I/O error
    const ENXIO             = 6;        // No such device or address
    const E2BIG             = 7;        // Argument list too long
    const ENOEXEC           = 8;        // Exec format error
    const EBADF             = 9;        // Bad file number
    const ECHILD            = 10;       // No child processes
    const EAGAIN            = 11;       // Try again
    const ENOMEM            = 12;       // Out of memory
    const EACCES            = 13;       // Permission denied
    const EFAULT            = 14;       // Bad address
    const EBUSY             = 16;       // Device or resource busy
    const EEXIST            = 17;       // File exists
    const EXDEV             = 18;       // Cross-device link
    const ENODEV            = 19;       // No such device
    const ENOTDIR           = 20;       // Not a directory
    const EISDIR            = 21;       // Is a directory
    const EINVAL            = 22;       // Invalid argument
    const ENFILE            = 23;       // File table overflow
    const EMFILE            = 24;       // Too many open files
    const ENOTTY            = 25;       // Not a typewriter
    const EFBIG             = 27;       // File too large
    const ENOSPC            = 28;       // No space left on device
    const ESPIPE            = 29;       // Illegal seek
    const EROFS             = 30;       // Read-only file system
    const EMLINK            = 31;       // Too many links
    const EPIPE             = 32;       // Broken pipe
    const EDOM              = 33;       // Math argument out of domain of func
    const ERANGE            = 34;       // Math result not representable
    const EDEADLK           = 36;       // Resource deadlock would occur
    const ENAMETOOLONG      = 38;       // File name too long
    const ENOLCK            = 39;       // No record locks available
    const ENOSYS            = 40;       // Function not implemented
    const ENOTEMPTY         = 41;       // Directory not empty
    const EILSEQ            = 42;       // Illegal byte sequence
    const EDEADLOCK         = EDEADLK;
}
else version( linux )
{
    const EPERM             = 1;        // Operation not permitted
    const ENOENT            = 2;        // No such file or directory
    const ESRCH             = 3;        // No such process
    const EINTR             = 4;        // Interrupted system call
    const EIO               = 5;        // I/O error
    const ENXIO             = 6;        // No such device or address
    const E2BIG             = 7;        // Argument list too long
    const ENOEXEC           = 8;        // Exec format error
    const EBADF             = 9;        // Bad file number
    const ECHILD            = 10;       // No child processes
    const EAGAIN            = 11;       // Try again
    const ENOMEM            = 12;       // Out of memory
    const EACCES            = 13;       // Permission denied
    const EFAULT            = 14;       // Bad address
    const ENOTBLK           = 15;       // Block device required
    const EBUSY             = 16;       // Device or resource busy
    const EEXIST            = 17;       // File exists
    const EXDEV             = 18;       // Cross-device link
    const ENODEV            = 19;       // No such device
    const ENOTDIR           = 20;       // Not a directory
    const EISDIR            = 21;       // Is a directory
    const EINVAL            = 22;       // Invalid argument
    const ENFILE            = 23;       // File table overflow
    const EMFILE            = 24;       // Too many open files
    const ENOTTY            = 25;       // Not a typewriter
    const ETXTBSY           = 26;       // Text file busy
    const EFBIG             = 27;       // File too large
    const ENOSPC            = 28;       // No space left on device
    const ESPIPE            = 29;       // Illegal seek
    const EROFS             = 30;       // Read-only file system
    const EMLINK            = 31;       // Too many links
    const EPIPE             = 32;       // Broken pipe
    const EDOM              = 33;       // Math argument out of domain of func
    const ERANGE            = 34;       // Math result not representable
    const EDEADLK           = 35;       // Resource deadlock would occur
    const ENAMETOOLONG      = 36;       // File name too long
    const ENOLCK            = 37;       // No record locks available
    const ENOSYS            = 38;       // Function not implemented
    const ENOTEMPTY         = 39;       // Directory not empty
    const ELOOP             = 40;       // Too many symbolic links encountered
    const EWOULDBLOCK       = EAGAIN;   // Operation would block
    const ENOMSG            = 42;       // No message of desired type
    const EIDRM             = 43;       // Identifier removed
    const ECHRNG            = 44;       // Channel number out of range
    const EL2NSYNC          = 45;       // Level 2 not synchronized
    const EL3HLT            = 46;       // Level 3 halted
    const EL3RST            = 47;       // Level 3 reset
    const ELNRNG            = 48;       // Link number out of range
    const EUNATCH           = 49;       // Protocol driver not attached
    const ENOCSI            = 50;       // No CSI structure available
    const EL2HLT            = 51;       // Level 2 halted
    const EBADE             = 52;       // Invalid exchange
    const EBADR             = 53;       // Invalid request descriptor
    const EXFULL            = 54;       // Exchange full
    const ENOANO            = 55;       // No anode
    const EBADRQC           = 56;       // Invalid request code
    const EBADSLT           = 57;       // Invalid slot
    const EDEADLOCK         = EDEADLK;
    const EBFONT            = 59;       // Bad font file format
    const ENOSTR            = 60;       // Device not a stream
    const ENODATA           = 61;       // No data available
    const ETIME             = 62;       // Timer expired
    const ENOSR             = 63;       // Out of streams resources
    const ENONET            = 64;       // Machine is not on the network
    const ENOPKG            = 65;       // Package not installed
    const EREMOTE           = 66;       // Object is remote
    const ENOLINK           = 67;       // Link has been severed
    const EADV              = 68;       // Advertise error
    const ESRMNT            = 69;       // Srmount error
    const ECOMM             = 70;       // Communication error on send
    const EPROTO            = 71;       // Protocol error
    const EMULTIHOP         = 72;       // Multihop attempted
    const EDOTDOT           = 73;       // RFS specific error
    const EBADMSG           = 74;       // Not a data message
    const EOVERFLOW         = 75;       // Value too large for defined data type
    const ENOTUNIQ          = 76;       // Name not unique on network
    const EBADFD            = 77;       // File descriptor in bad state
    const EREMCHG           = 78;       // Remote address changed
    const ELIBACC           = 79;       // Can not access a needed shared library
    const ELIBBAD           = 80;       // Accessing a corrupted shared library
    const ELIBSCN           = 81;       // .lib section in a.out corrupted
    const ELIBMAX           = 82;       // Attempting to link in too many shared libraries
    const ELIBEXEC          = 83;       // Cannot exec a shared library directly
    const EILSEQ            = 84;       // Illegal byte sequence
    const ERESTART          = 85;       // Interrupted system call should be restarted
    const ESTRPIPE          = 86;       // Streams pipe error
    const EUSERS            = 87;       // Too many users
    const ENOTSOCK          = 88;       // Socket operation on non-socket
    const EDESTADDRREQ      = 89;       // Destination address required
    const EMSGSIZE          = 90;       // Message too long
    const EPROTOTYPE        = 91;       // Protocol wrong type for socket
    const ENOPROTOOPT       = 92;       // Protocol not available
    const EPROTONOSUPPORT   = 93;       // Protocol not supported
    const ESOCKTNOSUPPORT   = 94;       // Socket type not supported
    const EOPNOTSUPP        = 95;       // Operation not supported on transport endpoint
    const EPFNOSUPPORT      = 96;       // Protocol family not supported
    const EAFNOSUPPORT      = 97;       // Address family not supported by protocol
    const EADDRINUSE        = 98;       // Address already in use
    const EADDRNOTAVAIL     = 99;       // Cannot assign requested address
    const ENETDOWN          = 100;      // Network is down
    const ENETUNREACH       = 101;      // Network is unreachable
    const ENETRESET         = 102;      // Network dropped connection because of reset
    const ECONNABORTED      = 103;      // Software caused connection abort
    const ECONNRESET        = 104;      // Connection reset by peer
    const ENOBUFS           = 105;      // No buffer space available
    const EISCONN           = 106;      // Transport endpoint is already connected
    const ENOTCONN          = 107;      // Transport endpoint is not connected
    const ESHUTDOWN         = 108;      // Cannot send after transport endpoint shutdown
    const ETOOMANYREFS      = 109;      // Too many references: cannot splice
    const ETIMEDOUT         = 110;      // Connection timed out
    const ECONNREFUSED      = 111;      // Connection refused
    const EHOSTDOWN         = 112;      // Host is down
    const EHOSTUNREACH      = 113;      // No route to host
    const EALREADY          = 114;      // Operation already in progress
    const EINPROGRESS       = 115;      // Operation now in progress
    const ESTALE            = 116;      // Stale NFS file handle
    const EUCLEAN           = 117;      // Structure needs cleaning
    const ENOTNAM           = 118;      // Not a XENIX named type file
    const ENAVAIL           = 119;      // No XENIX semaphores available
    const EISNAM            = 120;      // Is a named type file
    const EREMOTEIO         = 121;      // Remote I/O error
    const EDQUOT            = 122;      // Quota exceeded
    const ENOMEDIUM         = 123;      // No medium found
    const EMEDIUMTYPE       = 124;      // Wrong medium type
    const ECANCELED         = 125;      // Operation Canceled
    const ENOKEY            = 126;      // Required key not available
    const EKEYEXPIRED       = 127;      // Key has expired
    const EKEYREVOKED       = 128;      // Key has been revoked
    const EKEYREJECTED      = 129;      // Key was rejected by service
    const EOWNERDEAD        = 130;      // Owner died
    const ENOTRECOVERABLE   = 131;      // State not recoverable
}
else version( darwin )
{
    const EPERM             = 1;        // Operation not permitted
    const ENOENT            = 2;        // No such file or directory
    const ESRCH             = 3;        // No such process
    const EINTR             = 4;        // Interrupted system call
    const EIO               = 5;        // Input/output error
    const ENXIO             = 6;        // Device not configured
    const E2BIG             = 7;        // Argument list too long
    const ENOEXEC           = 8;        // Exec format error
    const EBADF             = 9;        // Bad file descriptor
    const ECHILD            = 10;       // No child processes
    const EDEADLK           = 11;       // Resource deadlock avoided
    const ENOMEM            = 12;       // Cannot allocate memory
    const EACCES            = 13;       // Permission denied
    const EFAULT            = 14;       // Bad address
    const EBUSY             = 16;       // Device busy
    const EEXIST            = 17;       // File exists
    const EXDEV             = 18;       // Cross-device link
    const ENODEV            = 19;       // Operation not supported by device
    const ENOTDIR           = 20;       // Not a directory
    const EISDIR            = 21;       // Is a directory
    const EINVAL            = 22;       // Invalid argument
    const ENFILE            = 23;       // Too many open files in system
    const EMFILE            = 24;       // Too many open files
    const ENOTTY            = 25;       // Inappropriate ioctl for device
    const ETXTBSY           = 26;       // Text file busy
    const EFBIG             = 27;       // File too large
    const ENOSPC            = 28;       // No space left on device
    const ESPIPE            = 29;       // Illegal seek
    const EROFS             = 30;       // Read-only file system
    const EMLINK            = 31;       // Too many links
    const EPIPE             = 32;       // Broken pipe
    const EDOM              = 33;       // Numerical argument out of domain
    const ERANGE            = 34;       // Result too large
    const EAGAIN            = 35;       // Resource temporarily unavailable
    const EWOULDBLOCK       = EAGAIN;   // Operation would block
    const EINPROGRESS       = 36;       // Operation now in progress
    const EALREADY          = 37;       // Operation already in progress
    const ENOTSOCK          = 38;       // Socket operation on non-socket
    const EDESTADDRREQ      = 39;       // Destination address required
    const EMSGSIZE          = 40;       // Message too long
    const EPROTOTYPE        = 41;       // Protocol wrong type for socket
    const ENOPROTOOPT       = 42;       // Protocol not available
    const EPROTONOSUPPORT   = 43;       // Protocol not supported
    const ENOTSUP           = 45;       // Operation not supported
    const EOPNOTSUPP        = ENOTSUP;  // Operation not supported on socket
    const EAFNOSUPPORT      = 47;       // Address family not supported by protocol family
    const EADDRINUSE        = 48;       // Address already in use
    const EADDRNOTAVAIL     = 49;       // Can't assign requested address
    const ENETDOWN          = 50;       // Network is down
    const ENETUNREACH       = 51;       // Network is unreachable
    const ENETRESET         = 52;       // Network dropped connection on reset
    const ECONNABORTED      = 53;       // Software caused connection abort
    const ECONNRESET        = 54;       // Connection reset by peer
    const ENOBUFS           = 55;       // No buffer space available
    const EISCONN           = 56;       // Socket is already connected
    const ENOTCONN          = 57;       // Socket is not connected
    const ETIMEDOUT         = 60;       // Operation timed out
    const ECONNREFUSED      = 61;       // Connection refused
    const ELOOP             = 62;       // Too many levels of symbolic links
    const ENAMETOOLONG      = 63;       // File name too long
    const EHOSTUNREACH      = 65;       // No route to host
    const ENOTEMPTY         = 66;       // Directory not empty
    const EDQUOT            = 69;       // Disc quota exceeded
    const ESTALE            = 70;       // Stale NFS file handle
    const ENOLCK            = 77;       // No locks available
    const ENOSYS            = 78;       // Function not implemented
    const EOVERFLOW         = 84;       // Value too large to be stored in data type
    const ECANCELED         = 89;       // Operation canceled
    const EIDRM             = 90;       // Identifier removed
    const ENOMSG            = 91;       // No message of desired type
    const EILSEQ            = 92;       // Illegal byte sequence
    const EBADMSG           = 94;       // Bad message
    const EMULTIHOP         = 95;       // Reserved
    const ENODATA           = 96;       // No message available on STREAM
    const ENOLINK           = 97;       // Reserved
    const ENOSR             = 98;       // No STREAM resources
    const ENOSTR            = 99;       // Not a STREAM
    const EPROTO            = 100;      // Protocol error
    const ETIME             = 101;      // STREAM ioctl timeout
    const ELAST             = 101;      // Must be equal largest errno
}
else version( freebsd )
{
    const EPERM             = 1;        // Operation not permitted
    const ENOENT            = 2;        // No such file or directory
    const ESRCH             = 3;        // No such process
    const EINTR             = 4;        // Interrupted system call
    const EIO               = 5;        // Input/output error
    const ENXIO             = 6;        // Device not configured
    const E2BIG             = 7;        // Argument list too long
    const ENOEXEC           = 8;        // Exec format error
    const EBADF             = 9;        // Bad file descriptor
    const ECHILD            = 10;       // No child processes
    const EDEADLK           = 11;       // Resource deadlock avoided
    const ENOMEM            = 12;       // Cannot allocate memory
    const EACCES            = 13;       // Permission denied
    const EFAULT            = 14;       // Bad address
    const ENOTBLK           = 15;       // Block device required
    const EBUSY             = 16;       // Device busy
    const EEXIST            = 17;       // File exists
    const EXDEV             = 18;       // Cross-device link
    const ENODEV            = 19;       // Operation not supported by device
    const ENOTDIR           = 20;       // Not a directory
    const EISDIR            = 21;       // Is a directory
    const EINVAL            = 22;       // Invalid argument
    const ENFILE            = 23;       // Too many open files in system
    const EMFILE            = 24;       // Too many open files
    const ENOTTY            = 25;       // Inappropriate ioctl for device
    const ETXTBSY           = 26;       // Text file busy
    const EFBIG             = 27;       // File too large
    const ENOSPC            = 28;       // No space left on device
    const ESPIPE            = 29;       // Illegal seek
    const EROFS             = 30;       // Read-only file system
    const EMLINK            = 31;       // Too many links
    const EPIPE             = 32;       // Broken pipe
    const EDOM              = 33;       // Numerical argument out of domain
    const ERANGE            = 34;       // Result too large
    const EAGAIN            = 35;       // Resource temporarily unavailable
    const EWOULDBLOCK       = EAGAIN;   // Operation would block
    const EINPROGRESS       = 36;       // Operation now in progress
    const EALREADY          = 37;       // Operation already in progress
    const ENOTSOCK          = 38;       // Socket operation on non-socket
    const EDESTADDRREQ      = 39;       // Destination address required
    const EMSGSIZE          = 40;       // Message too long
    const EPROTOTYPE        = 41;       // Protocol wrong type for socket
    const ENOPROTOOPT       = 42;       // Protocol not available
    const EPROTONOSUPPORT   = 43;       // Protocol not supported
    const ENOTSUP           = 45;       // Operation not supported
    const EOPNOTSUPP        = ENOTSUP;  // Operation not supported on socket
    const EAFNOSUPPORT      = 47;       // Address family not supported by protocol family
    const EADDRINUSE        = 48;       // Address already in use
    const EADDRNOTAVAIL     = 49;       // Can't assign requested address
    const ENETDOWN          = 50;       // Network is down
    const ENETUNREACH       = 51;       // Network is unreachable
    const ENETRESET         = 52;       // Network dropped connection on reset
    const ECONNABORTED      = 53;       // Software caused connection abort
    const ECONNRESET        = 54;       // Connection reset by peer
    const ENOBUFS           = 55;       // No buffer space available
    const EISCONN           = 56;       // Socket is already connected
    const ENOTCONN          = 57;       // Socket is not connected
    const ESHUTDOWN         = 58;       // Can't send after socket shutdown
    const ETOOMANYREFS      = 59;       // Too many refrences; can't splice
    const ETIMEDOUT         = 60;       // Operation timed out
    const ECONNREFUSED      = 61;       // Connection refused
    const ELOOP             = 62;       // Too many levels of symbolic links
    const ENAMETOOLONG      = 63;       // File name too long
    const EHOSTUNREACH      = 65;       // No route to host
    const ENOTEMPTY         = 66;       // Directory not empty
    const EPROCLIM          = 67;       // Too many processes
    const EUSERS            = 68;       // Too many users
    const EDQUOT            = 69;       // Disc quota exceeded
    const ESTALE            = 70;       // Stale NFS file handle
    const EREMOTE           = 71;       // Too many levels of remote in path
    const EBADRPC           = 72;       // RPC struct is bad
    const ERPCMISMATCH      = 73;       // RPC version wrong
    const EPROGUNAVAIL      = 74;       // RPC prog. not avail
    const EPROGMISMATCH     = 75;       // Program version wrong
    const EPROCUNAVAIL      = 76;       // Bad procedure for program
    const ENOLCK            = 77;       // No locks available
    const ENOSYS            = 78;       // Function not implemented
    const EFTYPE            = 79;       // Inappropriate file type or format
    const EAUTH             = 80;       // Authentication error
    const ENEEDAUTH         = 81;       // Need authenticator
    const EIDRM             = 82;       // Itendifier removed
    const ENOMSG            = 83;       // No message of desired type
    const EOVERFLOW         = 84;       // Value too large to be stored in data type
    const ECANCELED         = 85;       // Operation canceled
    const EILSEQ            = 86;       // Illegal byte sequence
    const ENOATTR           = 87;       // Attribute not found
    const EDOOFUS           = 88;       // Programming error
    const EBADMSG           = 89;       // Bad message
    const EMULTIHOP         = 90;       // Multihop attempted
    const ENOLINK           = 91;       // Link has been severed
    const EPROTO            = 92;       // Protocol error
    const ELAST             = 92;       // Must be equal largest errno
}
