/*!

\page gdcmscu Tool to execute a DICOM Query/Retrieve operation

\section synopsis SYNOPSIS

\verbatim
gdcmscu [OPTION]...[OPERATION]...HOSTNAME...[PORT]...
\endverbatim
Execute a DICOM Q/R operation to HOSTNAME, using port PORT (104 when not specified)

\section description DESCRIPTION

The \b gdcmscu command line program is the tool to execute DICOM Query/Retrieve operation.
It supports:
\li C-ECHO (SCU)
\li C-FIND (SCU)
\li C-STORE (SCU)
\li C-MOVE (SCU/SCP)
C-MOVE operation are executed using two different ports (one for the SCU and one for the SCP).

\section parameters PARAMETERS

\section options OPTIONS

\subsection options options
\verbatim
  -H --hostname       Hostname.
  -p --port           Port number.
     --aetitle        Set calling AE Title.
     --call           Set called AE Title.
\endverbatim

\subsection mode_options mode options
\verbatim
     --echo           C-ECHO (default when none).
     --store          C-STORE.
     --find           C-FIND.
     --move           C-MOVE.
\endverbatim

\subsection cstore_options C-STORE options
\verbatim
  -i --input          DICOM filename
  -r --recursive      recursively process (sub-)directories
     --store-query    Store constructed query in file
\endverbatim

\subsection cfind_options C-FIND/C-MOVE options
\verbatim
     --patientroot    C-FIND Patient Root Model.
     --studyroot      C-FIND Study Root Model.

     --patient        C-FIND Query on Patient Info (cannot be used with --studyroot).
     --study          C-FIND Query on Study Info.
     --series         C-FIND Query on Series Info.
     --image          C-FIND Query on Image Info.
     --key            0123,4567=VALUE for specifying search criteria (wildcard allowed)
                      With --key, leave blank (ie, --key 10,10="") to retrieve values
\endverbatim

\subsection cmove_options C-MOVE options
\verbatim
  -o --output     DICOM filename / directory
     --port-scp   Port for incoming associations
     --key            0123,4567=VALUE for specifying search criteria (wildcard not allowed)
                      Note that C-MOVE supports the same queries as C-FIND, but no wildcards are allowed
\endverbatim

\subsection general_options general options
\verbatim
  -h   --help
         print this help text and exit

  -v   --version
         print version information and exit

  -V   --verbose
         verbose mode (warning+error).

  -W   --warning
         warning mode, print warning information

  -E   --error
         error mode, print error information

  -D   --debug
         debug mode, print debug information
  --queryhelp
         print query help
\endverbatim

\subsection environment_variable environment variable
\verbatim
  GDCM_ROOT_UID Root UID
\endverbatim

\section cecho_usage C-ECHO usage
\b gdcmscu is a great tool to test if a DICOM server is up. For example to send
a C-ECHO to server dicom.example.com using port 104, use:

\verbatim
$ gdcmscu dicom.example.com
\endverbatim

or if you prefer being explicit:

\verbatim
$ gdcmscu --echo dicom.example.com 104
\endverbatim

Using basic security your DICOM server might require that you set the
appropriate called AE-TITLE

\verbatim
$ gdcmscu --echo dicom.example.com 11112 --call SERVSCP
\endverbatim

If you want to specifiy your own AE-TITLE (default is GDCMSCU), simply use:

\verbatim
$ gdcmscu --echo dicom.example.com 11112 --call SERVSCP --aetitle MYSCU
\endverbatim

For example you could test on the DICOM server provided by DICOMObject team:

\verbatim
$ gdcmscu www.dicomserver.co.uk 11112
\endverbatim

\section cstore_usage C-STORE usage
C-STORE is the operation that allow sending a DICOM file to a remote DICOM
server. For instance to send a file called myfile.dcm

\verbatim
$ gdcmscu --store dicom.example.com 104 myfile.dcm
\endverbatim

or if you prefer being explicit:

\verbatim
$ gdcmscu --store dicom.example.com 104 -i myfile.dcm
\endverbatim

You can even send multiple files using the same association:

\verbatim
$ gdcmscu --store dicom.example.com 104 myfile1.dcm myfile2.dcm myfile3.dcm ...
\endverbatim

\section cfind_usage C-FIND usage
\b gdcmscu also allow querying a DICOM server. This is the C-FIND operation,
for example to find all DICOM Instance where PatientsName match a particular
pattern, usage is simply:

\verbatim
$ gdcmscu --find --patient dicom.example.com 11112 --patientroot --key 10,10,"A*"
\endverbatim

We also support a DCMTK compatible convention:

\verbatim
$ gdcmscu --find --patient dicom.example.com 11112 --patientroot --key 10,10="A*"
\endverbatim

When an attribute is set without a value it will be part of the output result:

\verbatim
$ gdcmscu --find --patient dicom.example.com 11112 --call MI2B2 --patientroot -k 10,10="A*" -k 10,20
\endverbatim

\section cmove_usage C-MOVE usage
C-MOVE is the operation to retrieve a DICOM instance from a remote DICOM
server. Most of the time, it is a subsequent operation after a C-FIND query.
To retrieve a DICOM instance where PatientID is ABCD1234, simply execute:

\verbatim
$ gdcmscu --move --patient --aetitle ACME1 --call ACME_STORE dicom.example.com 5678 --patientroot -k 10,20="ABCD1234" --port-scp 1234
\endverbatim

WARNING For this operation to work you need information from the DICOM server
you are communicating with. Only the DICOM server you are sending a C-MOVE
query will be reponsible for sending back incoming associations (the actual
C-STORE SCP).
Therefore you need to make sure that you mapping of (AE-TITLE,PortNumber) is
properly set on the DICOM server side as well as the port for incoming
association (--port-scp).

\b gdcmscu does not currently support external C-STORE association (C-STORE
request sent to an external SCP application).

\section patientroot_notes patientroot notes

The flag --patientroot is just simply a wrapper around the syntax --key 8,52=PATIENT
For instance one would write using DCMTK syntax:

\verbatim
findscu --patient dicom.example.com 11112 --key 8,52=PATIENT --key 10,10="F*"
\endverbatim

This would become using GDCM syntax:

\verbatim
$ gdcmscu --find --patient dicom.example.com 11112 --patientroot --key 10,10="F*"
\endverbatim

\section debugging Debugging

This is sometime difficult to investigate why a connection to a remote DICOM server
cannot be done. Some recommendations follows:

Always try to do a simple C-ECHO at first. If you cannot get the C-ECHO to work
none of the other operations will work

Before trying to a C-MOVE operation, make sure you can execute the C-FIND equivalent
query first.

When doing a C-MOVE operation you really need to communicate with the PACS admin as
the C-MOVE operation is different from the other lower level operation such as HTTP/GET.
When doing a C-MOVE, the server will communicate back using another chanel (could be different
port) using it's internal database to map an AE-TITLE back to the destination IP.
Indeed the C-MOVE operation by design does not always use your incoming IP adress to send back
the resulting dataset. Instead it uses a mapping of AE-TITLE to IP adress to send back
any results. So pay particular attention to the spelling of your AE-TITLE and your incoming
port (which may be different from the port to connect to the server).

\section gdcmscu_portwarnings Port Warning

Watch out that port ranging [1-1024] are reserved for admin and not easily accessible unless
granted special priviliges. Therefore the default 104 DICOM port might be accessible to all
your users.

\section gdcmscu_ctorewarnings C-STORE Warnings

When constructing a C-STORE operation, gdcmscu will always use the Media Storage as found
in the file to be sent. For encapsulated DICOM file (eg. RLE Lossless) the receiving
SCP server might not support this compression and will legitemely refuse the C-STORE
operation. In this case users have to manually convert to a non-compressed form this particular file:

\verbatim
$ gdcmconv --raw compressed.dcm non_compressed.dcm
\endverbatim

\section gdcmscu_cmovewarnings C-MOVE Warnings

At the moment \b gdcmscu only supports non-compressed transfer syntax. It will
always request DataSet using Implicit VR Little Endian Transfer Syntax during a
C-MOVE operation.

\section gdcmscu_cfind_image C-FIND IMAGE level (Composite Object Instance)

One should pay attention that gdcmscu --find and findscu are not completely
equivalent. Using gdcmscu --find, all Unique Keys will be added automatically. One can
therefore execute something like this:

\verbatim
$ gdcmscu --find --patientroot --image --key 8,18=1.2.3.4.5.6 dicom.example.com 11112
\endverbatim

instead of the more explicit form

\verbatim
$ gdcmscu --find --patientroot --image --key 8,18=1.2.3.4.5.6 dicom.example.com 11112 --key 10,20 --key 20,d --key 20,e
\endverbatim

This would also be equivalent to:

\verbatim
$ findscu --patient --key 8,52=IMAGE --key 8,18=1.2.3.4.5.6 dicom.example.com 11112 --key 10,20 --key 20,d --key 20,e
\endverbatim

\section gdcmscu_storing Storing the Query

It is also possible to store the query:

\verbatim
gdcmscu --find --patient --patientroot dicom.example.com 11112 --key 10,20="*" --key 10,10 --store-query query.dcm
\endverbatim

One can then check the DataSet values send for the query:

\verbatim
$ gdcmdump query.dcm
# Dicom-File-Format

# Dicom-Meta-Information-Header
# Used TransferSyntax:

# Dicom-Data-Set
# Used TransferSyntax: 1.2.840.10008.1.2
(0008,0005) ?? (CS) [ISO_IR 192]                                  # 10,1-n Specific Character Set
(0008,0052) ?? (CS) [PATIENT ]                                    # 8,1 Query/Retrieve Level
(0010,0010) ?? (PN) (no value)                                    # 0,1 Patient's Name
(0010,0020) ?? (LO) [* ]                                          # 2,1 Patient ID
\endverbatim

The Specific Character Set was set to "ISO_IR 192" as the locale encoding of
the system was found automatically by gdcmscu to be UTF-8.

This means that the following command line will properly setup the Query with
the appropriate Charset to be executed correctly:

\verbatim
$ gdcmscu --find --patient --patientroot dicom.example.com 11112 --key 10,10="*Jérôme*"
\endverbatim

the query is always executed on the server side (SCP), some implementations does not support
string matching with different Character Set.

\section see_also SEE ALSO

<b>gdcmconv</b>(1)

\section copyright COPYRIGHT

Copyright Insight Software Consortium

*/
