#
# Rhythmlet - gDesklets sensor for Rhythmbox
# Copyright (c) 2004 Alex Revo
# ----------------------------------------------------------------------
#  RLBase.py - Debug class for Rhythmlet
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
########################################################################


# Import the required (system) modules.
import re
import socket
import sys
import traceback


class RLBase:
#-----------------------------------------------------------------------
	# To enable debugging messages set to 1
	_DEBUG = 1

	stripChars		= [ '`', '~', '!', '@', '#', '$', '%', '^', '*', '_', '[', '{', ']', '}', '|', '\\', ';', ':', '\'', '"', '<', ',', '>', '.', '?', '/' ]


	def __init__(self, *args):
	#-------------------------------------------------------------------
		# Set default time out to 30 seconds.
		socket.setdefaulttimeout(30)
	#-------------------------------------------------------------------


	def dPrint(self, message):
	#-------------------------------------------------------------------
		if (self._DEBUG):
			print "\x1b[31;01m[DEBUG]\x1b[0m " + str(message)
		# end if
	#-------------------------------------------------------------------


	def handleException(self, description, error):
	#-------------------------------------------------------------------
		# (http://www.linuxjournal.com/article.php?sid=5821)

		(excClass, excDetails, excTraceback) = sys.exc_info()
		excName = excClass.__name__
		excTb = traceback.format_tb(excTraceback, 5)

		try:
			excArgs = excDetails.__dict__["args"]
		except KeyError:
			excArgs = "<no args>"
		# end try

		self.dPrint("\x1b[32;01m[EXCEPTION]\x1b[0m \x1b[32;06m" + str(description) + "\x1b[0m")
#		self.dPrint("  " + str(error))
		self.dPrint("  " + str(excName) + ": " + str(excArgs))
		self.dPrint("  " + str(excTb))
		self.dPrint("\x1b[32;01m[/EXCEPTION]\x1b[0m")
	#-------------------------------------------------------------------


	def normalizeString(self, inStr):
	#-------------------------------------------------------------------
		inStr = inStr.lower()

		# fix various things
		inStr = inStr.replace("&", "and")
		inStr = re.sub(" ?\(dis[ck] \d+?\)", '', inStr)
		inStr = re.sub("^(the|a|an|el|le|les|la|los|die|der|das|den) ", '', inStr)
		inStr = re.sub(", (the|a|an|el|le|les|la|los|die|der|das|den)$", '', inStr)

		# replace all occurances of self.stripChars with nothing
		for charToStrip in self.stripChars:
			inStr = inStr.replace(charToStrip, '')
		# end for

		return(inStr)
	#-------------------------------------------------------------------
#-----------------------------------------------------------------------
