
/* This file implements a XSLT engine working on Gdome documents. In fact,
 * it just maps Gdome documents to libxml documents back and forth, and
 * applies the transformation on libxml documents using libxlt.
 * 
 * The code is largely based on the code of T.J. Mather's XML::GDOME::XSLT
 * Perl module (http://kobesearch.cpan.org/search?dist=XML-GDOME-XSLT)
 *
 * Copyright (C) 2002:
 * 	Claudio Sacerdoti Coen		<sacerdot@cs.unibo.it>
 * 	Stefano Zacchiroli		<zack@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please send an email to {sacerdot,zack}@cs.unibo.it
 */

#ifndef __gdome_xslt_h__
#define __gdome_xslt_h__

#include <gdome.h>
#include <libxslt/xsltconfig.h>
#include <libxslt/xslt.h>
#include <libxslt/xsltutils.h>
#include <libxslt/transform.h>
#include <libxslt/imports.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

	/******************************/
	/* XSLT stylesheet Processing */
	/******************************/

xsltStylesheetPtr	processStylesheet	(GdomeDocument* style);


	/*******************************/
	/* XSLT stylesheet Application */
	/*******************************/

GdomeDocument* 		applyStylesheet		(GdomeDocument* source,
						 xsltStylesheetPtr style_libxslt,
						 const char** params);

	/******************/
	/* Results Output */
	/******************/

int			saveResultToFilename	(const char* name,
		 				 GdomeDocument* result,
						 xsltStylesheetPtr style_libxslt,
						 int compression);
int 			saveResultToFile	(FILE* file,
						 GdomeDocument* result,
						 xsltStylesheetPtr style_libxslt);
int			saveResultToFd		(int fd,
						 GdomeDocument* result,
						 xsltStylesheetPtr style_libxslt);

	/**********************************************/
	/* Error and Debugging Callbacks Registration */
	/**********************************************/

typedef			void(*gdomeXsltMsgCallback)(const char *);

void 			setErrorCallback	(gdomeXsltMsgCallback callback);
void			setDebugCallback	(gdomeXsltMsgCallback callback);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __gdome_xslt_h__ */
