/* 
   collectiondata.c - 
   
   Part of GNU Enterprise Application Server (GEAS)

   Copyright (C) 2001 Free Software Foundation

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
   
   $Id: collectiondata.c,v 1.29 2001/07/25 17:48:24 reinhard Exp $

*/

#include "config.h"

#include <glib.h>
#include "geas-server.h"
#include "geas-skeleton.h"
#include "oql/oql.h"
#include "objectcache/objectcache.h"
#include "objectstore/objectstore.h"
#include "collectiondata.h"

typedef struct
{
  char *classname;
  ObjectKey key;
  GList *objects;
}
ObjectCollection_t;

/* static GList *object_collections = NULL; */

/* static ObjectCollection_t *allocate_object_collection (void); */

#ifndef MAX
#define MAX(a,b) ( (a) > (b) ? (a) : (b) )
#endif
#ifndef MIN
#define MIN(a,b) ( (a) < (b) ? (a) : (b) )
#endif

/* fill an object collection with data */
/* NOTE: query must provide object key as a string in field 'objectid' */
char *
new_object_collection_from_query (QueryData * query,
                                  GEAS_object_reference * xid,
                                  CORBA_Environment * ev)
{
  GEAS_DataObject lst;
  struct query_result *result;
  char *errmsg;
  int err;
  unsigned int i;
  int idx;
  char *classname;
  char buf[64];
  char *listid;
  char *id;
  char *lenstr;
  ObjectData *ob;               /* object cache entry */
  unsigned long int len;
  char *key;
  int   /* fieldid,*/ oididx;
  GList *hacklist = NULL;
  ObjectData *hackobj = NULL;

  timer_start_operation( TIMER_LISTS , "Start query: find list of objects" );
//  timer_start_profile( TIMER_FUNC_MAKELIST );

  if( using_postgresql() )
       start_objectstore_transaction();

  /* what class are we loading into the list? */
  classname = (char *) oql_query_get_classname (query);

  /* get list of object IDs from the object store */
  self_test_message ("Executing query");
  result = query_objectstore (query, &err, &errmsg);
  if (errmsg)
    {
      errormsg (errmsg);
      g_free (errmsg);
      if (result)
        {
          free_query_result (result);
        }
      if( using_postgresql() )
        commit_objectstore_transaction();
//      timer_update_profile( TIMER_FUNC_MAKELIST );
      timer_fail_operation( TIMER_LISTS );
      return (NULL);
    }
  timer_done_operation( TIMER_LISTS );
  if (!result)
    {
      self_test_message ("query failed");
      if( using_postgresql() )
        commit_objectstore_transaction();
//      timer_update_profile( TIMER_FUNC_MAKELIST );
      timer_fail_operation( TIMER_LISTS );
      return (NULL);
    }
  self_test_message ("query succeeded");

  /* place links into collection */
  timer_start_operation( TIMER_LISTS , "place query results in list" );
  idx = oql_query_get_field_position (query, "objectid");
  if (idx == (-1))
    {
      errormsg ("Invalid query to %s.", __PRETTY_FUNCTION__);
      if (result)
        {
          free_query_result (result);
        }
      if( using_postgresql() )
        commit_objectstore_transaction();
//      timer_update_profile( TIMER_FUNC_MAKELIST );
      timer_fail_operation( TIMER_LISTS );
      return (NULL);
    }

  /* create a base object for the list */
  lst = GEAS_Connection_newObject (xid->server, "geas::listholder", ev);
  if (ev->_major != CORBA_NO_EXCEPTION)
    {
      if( using_postgresql() )
        commit_objectstore_transaction();
//      timer_update_profile( TIMER_FUNC_MAKELIST );
      timer_fail_operation( TIMER_LISTS );
      return (NULL);
    }
//  hack_id = g_new0( GEAS_object_reference , 1 );
//  Connection_realNewObject( hack_id );
//  free_geas_object_reference( hack_id );
//  hack_id = NULL;

  GEAS_DataObject_setField (lst, "length", "0", ev);
  GEAS_DataObject_setField (lst, "classname", classname, ev);   /* what object, class */

  listid = GEAS_DataObject_getField (lst, "objectid", ev);
  if (ev->_major != CORBA_NO_EXCEPTION)
    {
      printf ("E %s\n", CORBA_exception_id (ev));
      if( using_postgresql() )
        commit_objectstore_transaction();
//      timer_update_profile( TIMER_FUNC_MAKELIST );
      timer_fail_operation( TIMER_LISTS );
      return (NULL);
    }
  hackobj = oc_find_cached_object_by_key( "geas::listholder" , listid );

  /* create list entry objects */
  len = count_rows_in_result (result);
  debug_output (DEBUGLEVEL_3, "List length: %d", len);

  if( len > 0 ) {
      GEAS_DataObject hackobj; /* a grep for the word 'hack' will be far too scary */

      ObjectKey keydata;
      int fieldid = oql_query_get_field_position(query,"objectid");
      GList *row = result->data;
      i = 0;
      while( row ) {
        /* char xyz[32]; */
/*          printf ("Item: %d of %d\n", i, len); */
          id = (char *) get_result_field (result, i /*row */ , idx /*field */ );

          /* record list position object */
          keydata = create_new_object_key ();
          /* printf( "geas::listitem/%s\n" , object_key_as_string(keydata) ); */
          ob = oc_add_empty_object ("geas::listitem", object_key_as_string (keydata));
          oc_set_object_flag (ob, of_indatabase, FLAG_ON);

          hacklist = g_list_prepend( hacklist , ob );
          g_free (keydata);
          sprintf (buf, "%d", i);
          oc_set_object_field_quick (ob, "position" , buf, FALSE);
          oc_set_object_field_quick (ob, "reference", id, FALSE);
/*       printf( "reference: '%s' '%s'\n" , id , oc_get_object_field(ob,"reference") ); */

          oc_set_object_field (ob, "listid"   , listid, FALSE);

          /* make sure the object is in the cache */
          oididx = fieldid = oql_query_get_field_position( query , "objectid" );
          g_assert( fieldid != -1 );
          key = get_field_in_row(row->data,fieldid);
          g_assert( key != NULL );
/*          printf( "key = '%s'\n" , key ); */

          ob = oc_add_empty_object( classname , key );
          oc_set_object_flag (ob, of_indatabase, FLAG_ON);

          /* make reference and store in object as userdata */
          if( oc_get_object_userdata(ob) == NULL ) {
            hackobj = make_dataobject_reference( classname , key , xid->username , xid->sessionid , ev );
            oc_set_object_userdata( ob , (void *)hackobj );
	  }

          for( fieldid=0 ; fieldid<result->field_count ; fieldid++ ) {
	    if( fieldid != oididx ) {
	    /* printf( "'%s' = '%s'\n" , get_result_field_name(result,fieldid) , get_field_in_row(row->data,fieldid) );  */
            oc_set_object_field_quick( ob , get_result_field_name(result,fieldid) ,
				       get_field_in_row(row->data,fieldid) , FALSE );
	    }
	  }

          row = g_list_next( row );
          i++;
      }
  }
  oc_set_object_userdata( hackobj , hacklist );
   if(0) {
   char buf[64];
   printf( "press enter\n" );
   gets(buf);
   }
  lenstr = g_strdup_printf ("%lu", len);
  GEAS_DataObject_setField (lst, "length", lenstr, ev);
  g_free (lenstr);

  /* done, successfully */
  free_query_result (result);

  if( using_postgresql() )
    commit_objectstore_transaction();

//  timer_update_profile( TIMER_FUNC_MAKELIST );
  timer_done_operation( TIMER_LISTS );
  /* printf( "cache stats after list creation: " ); */
  /* oc_print_stats(); */
  /* printf( "\n" ); */
  return (listid);
}

#ifdef SELF_TEST
void
self_test_objectcontainer (void)
{
  /* TODO */
  printf ("\nSelf test object container is not implemented.\n");
}
#endif
