/* 
   exceptions.h
   
   Part of GNU Enterprise Application Server (GEAS)

   Copyright (C) 2001 Free Software Foundation

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

   $Id: exceptions.h,v 1.8 2001/06/10 12:56:12 ntiffin Exp $
   
*/

#ifndef MAKE_EXCEPTIONS_H
#define MAKE_EXCEPTIONS_H

#include <glib.h>
#include "geas.h"

#define GEAS_EXCEPTIONID_UNKNOWN                 (-1)
#define GEAS_EXCEPTIONID_SYSTEM                  (-2)
#define GEAS_EXCEPTIONID_NONE                       0

#define GEAS_EXCEPTIONID_ServerError                1

#define GEAS_EXCEPTIONID_NotSupported               2
#define GEAS_EXCEPTIONID_NotAuthenticated           3
#define GEAS_EXCEPTIONID_AuthenticationError        4

#define GEAS_EXCEPTIONID_UnknownClass               5
#define GEAS_EXCEPTIONID_UnknownField               6
#define GEAS_EXCEPTIONID_UnknownFeature             7

#define GEAS_EXCEPTIONID_MethodError                8
#define GEAS_EXCEPTIONID_UnknownMethod              9
#define GEAS_EXCEPTIONID_ArgumentCount             10
#define GEAS_EXCEPTIONID_ReadOnlyField             11
#define GEAS_EXCEPTIONID_NotReferenceField         12
#define GEAS_EXCEPTIONID_NotListField              13
#define GEAS_EXCEPTIONID_NotLookupField            14
#define GEAS_EXCEPTIONID_NotReadable               15
#define GEAS_EXCEPTIONID_NotWriteable              16
#define GEAS_EXCEPTIONID_NotDataField              17
#define GEAS_EXCEPTIONID_NullField                 18

#define GEAS_EXCEPTIONID_WrongType                 19
#define GEAS_EXCEPTIONID_WrongClass                20

#define GEAS_EXCEPTIONID_Locked                    21
#define GEAS_EXCEPTIONID_TransactionNotInProgress  22
#define GEAS_EXCEPTIONID_TransactionInProgress     23
#define GEAS_EXCEPTIONID_CommitFailed              24
#define GEAS_EXCEPTIONID_RollbackFailed            25

#define GEAS_EXCEPTIONID_Interrupted               26
#define GEAS_EXCEPTIONID_InvalidArgument           27
#define GEAS_EXCEPTIONID_OutOfBounds               28

#define GEAS_EXCEPTIONID_FilterNotSet              29
#define GEAS_EXCEPTIONID_Format                    30

int get_user_exception_id( CORBA_Environment * ev );

void make_ServerError_exception(CORBA_Environment * ev, char *format, ...);

void make_NotSupported_exception(CORBA_Environment * ev, char *format, ...);
void make_NotAuthenticated_exception(CORBA_Environment * ev, char *format, ...);
void make_AuthenticationError_exception(CORBA_Environment * ev, char *format, ...);

void make_UnknownClass_exception(CORBA_Environment * ev, char *format, ...);
void make_UnknownField_exception(CORBA_Environment * ev, char *format, ...);
void make_UnknownFeature_exception(CORBA_Environment * ev, char *format, ...);

void make_MethodError_exception(CORBA_Environment * ev, char *format, ...);
void make_UnknownMethod_exception(CORBA_Environment * ev, char *format, ...);
void make_ArgumentCount_exception(CORBA_Environment * ev, int expected , int received , char *format, ...);
void make_ReadOnlyField_exception(CORBA_Environment * ev, char *format, ...);
void make_NotReferenceField_exception(CORBA_Environment * ev, char *format, ...);
void make_NotListField_exception(CORBA_Environment * ev, char *format, ...);
void make_NotLookupField_exception(CORBA_Environment * ev, char *format, ...);
void make_NotReadable_exception(CORBA_Environment * ev, char *format, ...);
void make_NotWriteable_exception(CORBA_Environment * ev, char *format, ...);
void make_NotDataField_exception(CORBA_Environment * ev, char *format, ...);
void make_NullField_exception(CORBA_Environment * ev, char *format, ...);

void make_WrongType_exception(CORBA_Environment * ev, char *format, ...);
void make_WrongClass_exception(CORBA_Environment * ev, char *format, ...);

void make_Locked_exception(CORBA_Environment * ev, char *format, ...);
void make_TransactionNotInProgress_exception(CORBA_Environment * ev, char *format, ...);
void make_TransactionInProgress_exception(CORBA_Environment * ev, char *format, ...);
void make_CommitFailed_exception(CORBA_Environment * ev, char *format, ...);
void make_RollbackFailed_exception(CORBA_Environment * ev, char *format, ...);

void make_Interrupted_exception(CORBA_Environment * ev, char *format, ...);
void make_InvalidArgument_exception(CORBA_Environment * ev, char *format, ...);
void make_OutOfBounds_exception(CORBA_Environment * ev, char *format, ...);

void make_FilterNotSet_exception(CORBA_Environment * ev, char *format, ...);

void make_Format_exception(CORBA_Environment * ev, char *format, ...);

#endif
