/* 
   servantlocator.h
   
   Part of GNU Enterprise Application Server (GEAS)

   Copyright (C) 2000 Free Software Foundation

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
   
   $Id: servantlocator.h,v 1.17 2001/06/12 19:12:30 reinhard Exp $

*/

#include <orb/corba_portableserver_type.h>
#include <orb/corba_portableserver.h>

#include "objectcache/objectcache.h"

extern POA_GEAS_Transaction poa_geas_transaction_servant;
extern POA_GEAS_Connection poa_geas_connection_servant;
extern POA_GEAS_DataObject poa_geas_dataobject_servant;
extern POA_GEAS_ObjectList poa_geas_objectlist_servant;
extern POA_GEAS_Admin poa_geas_admin_servant;
extern POA_GEAS_Query_Constraint poa_geas_query_constraint_servant;
extern POA_GEAS_Query_Query poa_geas_query_query_servant;

void create_fake_servants (PortableServer_POA root_poa,
                           CORBA_Environment * ev);
void free_fake_servants (void);

/* locator functions */
static PortableServer_Servant
preinvoke_query (PortableServer_ObjectId * oid, PortableServer_POA adapter,
                 CORBA_Identifier op_name,
                 PortableServer_ServantLocator_Cookie * cookie)
{
  /* Question: should this even exist?  :) */
  return ((PortableServer_Servant) & poa_geas_query_query_servant);
}

static void
postinvoke_query (PortableServer_Servant s, PortableServer_ObjectId * oid,
                  PortableServer_POA adapter, CORBA_Identifier op_name,
                  PortableServer_ServantLocator_Cookie cookie,
                  PortableServer_Servant servant)
{
}

static PortableServer_Servant
preinvoke_constraint (PortableServer_ObjectId * oid,
                      PortableServer_POA adapter, CORBA_Identifier op_name,
                      PortableServer_ServantLocator_Cookie * cookie)
{
  /* Question: should this even exist?  :) */
  return ((PortableServer_Servant) & poa_geas_query_constraint_servant);
}

static void
postinvoke_constraint (PortableServer_Servant s,
                       PortableServer_ObjectId * oid,
                       PortableServer_POA adapter, CORBA_Identifier op_name,
                       PortableServer_ServantLocator_Cookie cookie,
                       PortableServer_Servant servant)
{
}

static PortableServer_Servant
preinvoke_connection (PortableServer_ObjectId * oid,
                      PortableServer_POA adapter, CORBA_Identifier op_name,
                      PortableServer_ServantLocator_Cookie * cookie)
{
  /* Question: should this even exist?  :) */
  return ((PortableServer_Servant) & poa_geas_connection_servant);
}

static void
postinvoke_connection (PortableServer_Servant s,
                       PortableServer_ObjectId * oid,
                       PortableServer_POA adapter, CORBA_Identifier op_name,
                       PortableServer_ServantLocator_Cookie cookie,
                       PortableServer_Servant servant)
{
}

static PortableServer_Servant
preinvoke_transaction (PortableServer_ObjectId * oid,
                       PortableServer_POA adapter, CORBA_Identifier op_name,
                       PortableServer_ServantLocator_Cookie * cookie)
{
  /* Question: should this even exist?  :) */
  return ((PortableServer_Servant) & poa_geas_transaction_servant);
}

static void
postinvoke_transaction (PortableServer_Servant s,
                        PortableServer_ObjectId * oid,
                        PortableServer_POA adapter, CORBA_Identifier op_name,
                        PortableServer_ServantLocator_Cookie cookie,
                        PortableServer_Servant servant)
{
}

static PortableServer_Servant
preinvoke_objectlist (PortableServer_Servant servant,
                      PortableServer_ObjectId * oid,
                      PortableServer_POA adapter, CORBA_Identifier op_name,
                      PortableServer_ServantLocator_Cookie * cookie)
{
  /* TODO: check for existance of the object with the given ID, and return NULL if not found */
  GEAS_object_reference *id = NULL;
  PortableServer_Servant retval = NULL;
  CORBA_Environment ev;

  CORBA_exception_init (&ev);

  id = corba_id_to_geas_reference (oid, &ev);
  if (ev._major != CORBA_NO_EXCEPTION)
    {
      errormsg (CORBA_exception_id (&ev));
      CORBA_exception_free (&ev);
      return (NULL);
    }

  CORBA_exception_free (&ev);
  if (id)
    {
      if (oc_validate_object ("geas::listholder", id->listid))
        retval = (PortableServer_Servant) & poa_geas_objectlist_servant;
      free_geas_object_reference (id);
    }

  return (retval);
}

static void
postinvoke_objectlist (PortableServer_Servant s,
                       PortableServer_ObjectId * oid,
                       PortableServer_POA adapter, CORBA_Identifier op_name,
                       PortableServer_ServantLocator_Cookie cookie,
                       PortableServer_Servant servant)
{
}

static PortableServer_Servant
preinvoke_dataobject (PortableServer_Servant servant,
                      PortableServer_ObjectId * oid,
                      PortableServer_POA adapter, CORBA_Identifier op_name,
                      PortableServer_ServantLocator_Cookie * cookie)
{
  /* TODO: check for existance of the object with the given ID, and return NULL if not found */
  GEAS_object_reference *id = NULL;
  PortableServer_Servant retval = NULL;
  CORBA_Environment ev;

  CORBA_exception_init (&ev);

  id = corba_id_to_geas_reference (oid, &ev);
  if (ev._major != CORBA_NO_EXCEPTION)
    {
      errormsg (CORBA_exception_id (&ev));
      CORBA_exception_free (&ev);
      return (NULL);
    }

  CORBA_exception_free (&ev);
  if (id)
    {
      if (oc_validate_object (id->classname, id->objectid))
        {
          retval = (PortableServer_Servant) & poa_geas_dataobject_servant;
        }
      else
        {
          Connection_realNewObject (id);
          if (oc_validate_object (id->classname, id->objectid))
            retval = (PortableServer_Servant) & poa_geas_dataobject_servant;
        }
      free_geas_object_reference (id);
    }

  return (retval);
}

static void
postinvoke_dataobject (PortableServer_Servant s,
                       PortableServer_ObjectId * oid,
                       PortableServer_POA adapter, CORBA_Identifier op_name,
                       PortableServer_ServantLocator_Cookie cookie,
                       PortableServer_Servant servant)
{
}

static PortableServer_Servant
preinvoke_admin (PortableServer_Servant servant,
                 PortableServer_ObjectId * oid, PortableServer_POA adapter,
                 CORBA_Identifier op_name,
                 PortableServer_ServantLocator_Cookie * cookie)
{
  /* Question: should this even exist?  :) */
  return ((PortableServer_Servant) & poa_geas_admin_servant);
}

static void
postinvoke_admin (PortableServer_Servant s, PortableServer_ObjectId * oid,
                  PortableServer_POA adapter, CORBA_Identifier op_name,
                  PortableServer_ServantLocator_Cookie cookie,
                  PortableServer_Servant servant)
{
}



/* pointers to actual ServantLocator instances */
static PortableServer_ServantManager poa_servantmanager_connection =
  CORBA_OBJECT_NIL;
static PortableServer_ServantManager poa_servantmanager_dataobject =
  CORBA_OBJECT_NIL;
static PortableServer_ServantManager poa_servantmanager_objectlist =
  CORBA_OBJECT_NIL;
static PortableServer_ServantManager poa_servantmanager_admin =
  CORBA_OBJECT_NIL;
static PortableServer_ServantManager poa_servantmanager_transaction =
  CORBA_OBJECT_NIL;

static PortableServer_ServantManager poa_servantmanager_constraint =
  CORBA_OBJECT_NIL;
static PortableServer_ServantManager poa_servantmanager_query =
  CORBA_OBJECT_NIL;

static POA_PortableServer_ServantLocator__epv connection_epv = {
  NULL, /* _private */ (gpointer) & preinvoke_connection, (gpointer) & postinvoke_connection
};
static POA_PortableServer_ServantLocator__epv transaction_epv = {
  NULL, /* _private */ (gpointer) & preinvoke_transaction, (gpointer) & postinvoke_transaction
};
static POA_PortableServer_ServantLocator__epv dataobject_epv = {
  NULL, /* _private */ (gpointer) & preinvoke_dataobject, (gpointer) & postinvoke_dataobject
};
static POA_PortableServer_ServantLocator__epv objectlist_epv = {
  NULL, /* _private */ (gpointer) & preinvoke_objectlist, (gpointer) & postinvoke_objectlist
};
static POA_PortableServer_ServantLocator__epv admin_epv = {
  NULL, /* _private */ (gpointer) & preinvoke_admin, (gpointer) & postinvoke_admin
};
static POA_PortableServer_ServantLocator__epv query_epv = {
  NULL, /* _private */ (gpointer) & preinvoke_query, (gpointer) & postinvoke_query
};
static POA_PortableServer_ServantLocator__epv constraint_epv = {
  NULL, /* _private */ (gpointer) & preinvoke_constraint, (gpointer) & postinvoke_constraint
};

typedef struct
{
  POA_PortableServer_ServantLocator servant;
  PortableServer_POA poa;
  /* no other object state */
}
impl_POA_PortableServer_ServantLocator;

/* servant locator base */
PortableServer_ServantBase__epv base_epv = {
  NULL,                         /* _private */
  NULL,                         /* finalise */
  NULL                          /* default_POA */
};

/* servant manager, no functions? */
POA_PortableServer_ServantManager__epv crapthing = { NULL };

/* servant locator, needs to be able to find methods */
static POA_PortableServer_ServantLocator__vepv transaction_vepv = {
  &base_epv, &crapthing, &transaction_epv
};
static POA_PortableServer_ServantLocator__vepv connection_vepv = {
  &base_epv, &crapthing, &connection_epv
};
static POA_PortableServer_ServantLocator__vepv dataobject_vepv = {
  &base_epv, &crapthing, &dataobject_epv
};
static POA_PortableServer_ServantLocator__vepv objectlist_vepv = {
  &base_epv, &crapthing, &objectlist_epv
};
static POA_PortableServer_ServantLocator__vepv admin_vepv = {
  &base_epv, &crapthing, &admin_epv
};
static POA_PortableServer_ServantLocator__vepv query_vepv = {
  &base_epv, &crapthing, &query_epv
};
static POA_PortableServer_ServantLocator__vepv constraint_vepv = {
  &base_epv, &crapthing, &constraint_epv
};

typedef struct
{
  POA_PortableServer_ServantLocator servant;
  PortableServer_POA poa;
}
impl_POA_ServantLocator;
/*
static PortableServer_ServantLocator *connection_locator;
static PortableServer_ServantLocator *dataobject_locator;
static PortableServer_ServantLocator *objectlist_locator;
static PortableServer_ServantLocator *admin_locator;
static PortableServer_ServantLocator *transaction_locator;
static PortableServer_ServantLocator *query_locator;
static PortableServer_ServantLocator *constraint_locator;
*/
static PortableServer_ServantManager
create_locator (PortableServer_POA root_poa,
                POA_PortableServer_ServantLocator__vepv * vepv,
                CORBA_Environment * ev)
{
  impl_POA_ServantLocator *newservant = NULL;
  PortableServer_ObjectId *objid;

  newservant = g_new0 (impl_POA_ServantLocator, 1);
  newservant->servant.vepv = vepv;
  POA_PortableServer_ServantLocator__init ((PortableServer_Servant)
                                           newservant, ev);
  objid = PortableServer_POA_activate_object (root_poa, newservant, ev);
  /* printf( "locator objectid: %s\n" , PortableServer_ObjectId_to_string(objid,ev) ); */
  CORBA_free (objid);

  return ((PortableServer_ServantManager) newservant);
}


void
create_fake_servants (PortableServer_POA root_poa, CORBA_Environment * ev)
{
  message ("Creating locator objects");

  /* Transaction */
  poa_servantmanager_transaction =
    create_locator (root_poa, &transaction_vepv, ev);

  /* Connection */
  poa_servantmanager_connection =
    create_locator (root_poa, &connection_vepv, ev);

  /* Data Object */
  poa_servantmanager_dataobject =
    create_locator (root_poa, &dataobject_vepv, ev);

  /* Object List */
  poa_servantmanager_objectlist =
    create_locator (root_poa, &objectlist_vepv, ev);

  /* Admin */
  poa_servantmanager_admin = create_locator (root_poa, &admin_vepv, ev);

  /* Query */
  poa_servantmanager_query = create_locator (root_poa, &query_vepv, ev);

  /* Constraint */
  poa_servantmanager_constraint =
    create_locator (root_poa, &constraint_vepv, ev);
}

void
free_fake_servants (void)
{
  /* TODO: */

  /* remove locator objects */

  /* remove fake servants */
}
