/* gEDA - GPL Electronic Design Automation
 * gsymcheck - gEDA Symbol Check 
 * Copyright (C) 1998-2000 Ales V. Hvezda
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>
#include <stdio.h>
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#include <signal.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <libgeda/libgeda.h>

#include "../include/globals.h"
#include "../include/prototype.h"


void
gsymcheck_quit(void)
{
	s_clib_cache_free();
        s_clib_free();
        s_slib_free();
        /* o_text_freeallfonts();*/

}

void 
main_prog(int argc, char *argv[])
{
  int i;
  int argv_index;
  int first_page=1;
  int errors;
  char *cwd;

  TOPLEVEL *pr_current;

  argv_index = parse_commandline(argc, argv);
  cwd = getcwd(NULL, 1024);

  libgeda_init();

  /* create log file right away */
  /* even if logging is enabled */
  s_log_init(cwd, "gsymcheck.log");
  free(cwd);
	
  s_log_message(
                "gEDA/gsymcheck version %s\n", VERSION);
  s_log_message(
                "gEDA/symcheck comes with ABSOLUTELY NO WARRANTY; see COPYING for more details.\n");
  s_log_message(
                "This is free software, and you are welcome to redistribute it under certain\n");
  s_log_message(
                "conditions; please see the COPYING file for more details.\n\n"); 

  if (!quiet_mode) {
    fprintf(stderr, 
            "gEDA/symcheck version %s\n", VERSION);
    fprintf(stderr, 
            "gEDA/symcheck comes with ABSOLUTELY NO WARRANTY; see COPYING for more details.\n");
    fprintf(stderr, 
            "This is free software, and you are welcome to redistribute it under certain\n");
    fprintf(stderr, 
            "conditions; please see the COPYING file for more details.\n\n"); 
  }

#ifdef __CYGWIN32__
  fprintf(stderr, "This is the CYGWIN port.  It is unstable.\n");
  fprintf(stderr, "USE AT YOUR OWN RISK!\n");
#endif  

  /* register guile (scheme) functions */
  g_register_funcs();

  s_clib_init();
  s_slib_init();

  s_project_add_head();

  pr_current = s_project_create_new();

  i = argv_index;
  while (argv[i] != NULL) {
    if (first_page) {
      if (pr_current->page_current->page_filename) {
        free(pr_current->page_current->page_filename);
      }

      /* Page structure has already been created... */	
      /* so, just set the filename and open the schematic */
      /* for the first page */

      pr_current->page_current->page_filename = malloc(
                                                       sizeof(char)*strlen(argv[i])+5);
      strcpy(pr_current->page_current->page_filename, 
             argv[i]);

      if (verbose_mode) {
        printf("Loading file [%s]\n", argv[i]);
      }
      f_open(pr_current, pr_current->page_current->page_filename);
      first_page = 0;
    } else {

      /* now are there any other filenames specified? */
      /* Much simpler	*/
      if (verbose_mode) {
        printf("Loading file [%s]\n", argv[i]);
      }
      if (!s_page_new(pr_current, argv[i])) {
        f_open(pr_current, pr_current->
               page_current->page_filename);
      }
    }
    i++;
  }

  if (argv[argv_index] == NULL) {
    fprintf(stderr, "\nERROR! You must specify at least one filename\n\n");
    usage(argv[0]);
  }

#if DEBUG 
  s_page_print_all(pr_current);
#endif

  if (verbose_mode) printf("\n");

  errors = s_check_all(pr_current);
  
  gsymcheck_quit();
  exit(errors);
}

int 
main (int argc, char *argv[])
{
  gh_enter (argc, argv, main_prog);
  return 0;
}
