/* $Id */
/* $Log */
#include <X11/Intrinsic.h>

typedef struct _XgApplicationData {
	Boolean         initialized;
	XtAppContext    app_con;
	Display        *display;
}               XgApplicationData;

static XgApplicationData application_data = {
	False,
	NULL,
	NULL
};

void            XgInitialize();
void            XgEventLoop();
XtAppContext    XgAppContext();
Display        *XgDisplay();

/* These are the default resources to use if the user does not have his own
 * X resource file.
 */
String          fallback_resources[] = {
	"*borderWidth: 2",
	"*borderColor: LightSteelBlue",
	"*background: LightSteelBlue",
	NULL
};

/* @@SECTION XgInitialize */
void 
XgInitialize()
{
	int             argc = 0;
	String          argv[1];

	if (application_data.initialized)
		return;


	printf("\n----------------------- Starting XODUS 2.0 -----------------------\n\n");

	/* Initialize the X Toolkit internals */
	XtToolkitInitialize();

	/* Every application must have an application context */
	application_data.app_con = XtCreateApplicationContext();

	/* Specify default set of resource values. */
	XtAppSetFallbackResources(application_data.app_con, fallback_resources);

	/* Connect a client program to an X server */
	if (!(application_data.display = XOpenDisplay(""))) {
		XgError("Couldn't open display.  Check DISPLAY envariable");
		application_data.display = NULL;
		return;
	}
	application_data.initialized = True;

	/* Initialize and add the display above to the application context. */
	XtDisplayInitialize(application_data.app_con, application_data.display,
			    "genesis", "Genesis", NULL, 0, &argc, argv);

	/* Set up the colorscale */
	XoInitColorscale();

	/* Set up the cursor */
	XoInitCursor();

	/*
	 * Presumably AddJob adds the function XgEventLoop as a job in the
	 * GENESIS loop.
	 */
	AddJob(XgEventLoop, 1);

}

/* @@SECTION XgEventLoop */
void 
XgEventLoop()
{
	XEvent          event;

	/* Returns non zero if there are any Xevents on the queue. */
	while (XtAppPending(application_data.app_con) != 0) {

		/* Get next event from the X event queue. */
		XtAppNextEvent(application_data.app_con, &event);

		XtDispatchEvent(&event);
	}
}

/* @@SECTION XgAppContext */
/* Accessor functions */
XtAppContext XgAppContext()
{
	return application_data.app_con;
}

/* @@SECTION XgDisplay */
Display        *XgDisplay()
{
	return application_data.display;
}
