#include "sim_ext.h"

/** 
    Callback for the quit command - calls stage 1 quit
    which invokes the QUIT action for all elements in element tree 
**/

void quitCallback()
{
	void QuitStage1();

	Element * element = RootElement();
	QuitStage1(element);
}

void QuitStage1(element)
 Element *element;
{

	static Action quit_action = { "QUIT", QUIT, NULL, 0, NULL, NULL };

	if(element->child){
		/*
		** recursively do it for the children
		*/
		QuitStage1(element->child);
	}

    /*
    ** try to call any special quit function nestled away in the QUIT action
    */

    	CallActionsSubToBase(element, element->object, &quit_action);

    	if(element->next){
       	 /*
       	 ** and the siblings
       	 */
       	 QuitStage1(element->next);
    	}

}
