static char rcsid[] = "$Id: jump.c,v 1.7 1997/08/08 19:26:29 dhb Exp $";

/*
** $Log: jump.c,v $
** Revision 1.7  1997/08/08 19:26:29  dhb
** Added check for __GLIBC__ (the new glibc c library) and define
** a sigcontext structure for this case.
**
** Revision 1.6  1996/06/06 20:53:55  dhb
** merged in 1.4.1.1 changes.
**
** Revision 1.5  1996/05/23  23:17:48  dhb
** t3d/e port
**
** Revision 1.4.1.1  1996/06/06  20:06:33  dhb
** Paragon port.
**
** Revision 1.4  1995/02/22  19:11:10  dhb
** Linux support.
**
** Revision 1.3  1993/10/05  20:14:47  dhb
** Fixed mistake in application of Solaris patches.
**
** Revision 1.2  1993/09/17  20:13:08  dhb
** Solaris compatability.
**
** Revision 1.1  1992/12/11  19:05:30  dhb
** Initial revision
**
*/

#include <math.h>
#include <stdio.h>
#include <signal.h>
#include <setjmp.h>

/* mds3 changes */
#include "system_deps.h"

#if (defined(i860) && !defined(paragon)) || (defined(Linux) && !defined(__GLIBC)) || defined(CRAY)  
struct sigcontext
{
  int xyzzy;
};
#endif

extern jmp_buf	main_context;

#ifndef Solaris
struct sigcontext sig_context;

save_context(sig,code,scp)
int		sig,code;
struct sigcontext *scp;
{
	/*
	** save the context for later return
	*/
	bcopy(scp,&sig_context,sizeof(struct sigcontext));
}
#endif

#ifdef Solaris
restore_context(sig,code)
int		sig,code;
{
	/*
	** restore the earlier context
	lprintf("\ninterrupted\n");
	*/
	printf("\n");
	longjmp(main_context,1);
}
#else
restore_context(sig,code,scp)
int		sig,code;
struct sigcontext *scp;
{
	/*
	** restore the earlier context
	lprintf("\ninterrupted\n");
	*/
	printf("\n");
	longjmp(main_context,1);
}
#endif

#ifdef DEPENDENT
sig_msg_restore_context(sig,code,scp)
int		sig,code;
struct sigcontext *scp;
{
char *file;
char *FindSrcLine();
int line;
extern int sig_msg();

	file = FindSrcLine(scp->sc_pc,&line);
	if(file != NULL){
		printf("\nerror in %s at line %d\n",file,line);
	} else {
		printf("\nerror at pc = %d\n",scp->sc_pc);
	}
	sig_msg(sig,code,scp);
	restore_context(sig,code,scp);
}
#elif defined(Solaris)
sig_msg_restore_context(sig,code)
int		sig,code;
{
char *file;
int line;
extern int sig_msg();

    TraceScript();
    sig_msg(sig,code);
    restore_context(sig,code);
}
#else
sig_msg_restore_context(sig,code,scp)
int		sig,code;
struct sigcontext *scp;
{
char *file;
int line;
extern int sig_msg();

    TraceScript();
    sig_msg(sig,code,scp);
    restore_context(sig,code,scp);
}
#endif

