#include "vektor.h"
#include "printer.h"
#include "parser.h"
#include "gfanapplication.h"

class XfigConstructionApplication : public GFanApplication
{
public:
  bool includeInDefaultInstallation()
  {
    return false;
  }
  XfigConstructionApplication()
  {
    registerOptions();
  }
  char *name()
  {
    return "_xfigconstruction";
  }
  int main()
  {
    int dimension=4;
    FileParser P(Stdin);
    IntegerVectorList a=P.parseIntegerVectorList();
    IntegerVectorList b=P.parseIntegerVectorList();
    IntegerVector invertVector=P.parseIntegerVector();

    int nEdges=a.begin()->size();
    int nCycles=a.size()/dimension;
    fprintf(Stderr,"nEdges %i nCycles %i\n",nEdges,nCycles);

    for(int i=0;i<nEdges;i++)
      {
	IntegerVector direction(dimension);

	IntegerVectorList::const_iterator J=a.begin();
	for(int j=0;j<nCycles;j++)
	  {
	    for(int k=0;k<dimension;k++)
	      {
		direction[k]=(*J)[i];
		J++;
	      }
	    if(dot(direction,direction))break;
	  }
	direction=invertVector[i]*direction;
	IntegerVector scaleVectorSum(dimension);
	if(dot(direction,direction))
	  {
	    IntegerVectorList::const_iterator J=a.begin();
	    for(int j=0;j<nCycles;j++)
	      {
		IntegerVector cycleVector(dimension);
		for(int k=0;k<dimension;k++)
		  {
		    cycleVector[k]=(*J)[i];
		    J++;
		  }
		int sign=dot(cycleVector,direction)/dot(direction,direction);
		
		IntegerVector scaleVector(dimension);
		for(int k=0;k<dimension;k++)
		  {
		    scaleVector[k]=(*b.begin())[j*4+k];
		  }
		scaleVectorSum+=sign*scaleVector;
	      }
	    if(!scaleVectorSum.isZero())
	      {
		fprintf(Stderr,"%i:",i);
		AsciiPrinter(Stderr).printVector(direction);
		AsciiPrinter(Stderr).printVector(scaleVectorSum);
		
		fprintf(Stderr," %i\n",dot(direction,scaleVectorSum));
		fprintf(Stdout,"4 0 0 50 -1 0 6 0.0000 6 480 2805 3375 3675 ");
		fprintf(Stdout,"$\\\\left(\\\\begin{tabular}{c}");
		for(int k=0;k<dimension;k++)
		  {
		    if(k)fprintf(Stdout,"\\\\\\\\");
		    fprintf(Stdout," %i ",scaleVectorSum[k]);
		  }
		fprintf(Stdout,"\\\\end{tabular}\\\\right)");
		fprintf(Stdout,"\\\\cdot s_{%i}",i);
		fprintf(Stdout,"\\\\left(\\\\begin{tabular}{c}");
		for(int k=0;k<dimension;k++)
		  {
		    if(k)fprintf(Stdout,"\\\\\\\\");
		    fprintf(Stdout," %i ",direction[k]);
		  }
		fprintf(Stdout,"\\\\end{tabular}\\\\right)$");
		fprintf(Stdout,"\\001\n");
		
	      }	    
	  }
      }

    AsciiPrinter(Stdout).printVectorList(multiplyIntegerVectorList(a,b));
    return 0;
  }
  const char *helpText()
  {
    return "This program should not be in the final release. It is used for generating xfig files for showing non realizable state polyhedra.\n";
  }
};

static XfigConstructionApplication theApplication;
