#ifndef SYMMETRY_H_INCLUDED
#define SYMMETRY_H_INCLUDED

#include <stdio.h>
#include <set>
#include "vektor.h"
#include "polynomial.h"
#include "termorder.h"

class SymmetryGroup{
 public:
  typedef set<IntegerVector,LexicographicTermOrder> ElementContainer;
  ElementContainer elements;
  int sizeOfBaseSet();
  static IntegerVectorList permuteIntegerVectorList(IntegerVectorList const &l, IntegerVector const &v);
  static Polynomial permutePolynomial(const Polynomial &p, IntegerVector const &v);
  static PolynomialSet permutePolynomialSet(PolynomialSet const &s, IntegerVector const &v);
  Polynomial computeUniqueRepresentative(Polynomial p);
  static IntegerVector compose(IntegerVector const &a, IntegerVector const &b);
  static IntegerVector composeInverse(IntegerVector const &a, IntegerVector const &b);
  static IntegerVector identity(int numberOfElements);
  static IntegerVector inverse(IntegerVector const &a);
  SymmetryGroup(int n);
  void computeClosure(IntegerVector const &v);
  void computeClosure(IntegerVectorList const &l);
  void print(FILE *f);
};

#endif
