/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  adjustmentsignals.cc - Gtk::Adjustment virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "adjustment.hh"
#include "adjustmentsignals.hh"
#include "private/adjustmentclass.hh"

using namespace GFC;

/*  Gtk::AdjustmentSignals
 */

Gtk::AdjustmentSignals::AdjustmentSignals(Adjustment *adjustment)
: ObjectSignals(adjustment)
{
	Gtk::AdjustmentClass::init(GTK_ADJUSTMENT_GET_CLASS(adjustment->gtk_adjustment()));
}

Gtk::AdjustmentSignals::~AdjustmentSignals()
{
}

void
Gtk::AdjustmentSignals::on_changed()
{
	GtkAdjustmentClass *g_class = AdjustmentClass::get_parent_class(instance_);
	if (g_class->changed)
		g_class->changed((GtkAdjustment*)instance_);
}

void
Gtk::AdjustmentSignals::on_value_changed()
{
	GtkAdjustmentClass *g_class = AdjustmentClass::get_parent_class(instance_);
	if (g_class->value_changed)
		g_class->value_changed((GtkAdjustment*)instance_);
}

/*  Gtk::AdjustmentClass
 */

void
Gtk::AdjustmentClass::init(GtkAdjustmentClass *g_class)
{
	g_class->changed = &changed_proxy;
	g_class->value_changed = &value_changed_proxy;
}

GtkAdjustmentClass*
Gtk::AdjustmentClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_ADJUSTMENT_GET_CLASS(instance));
	return static_cast<GtkAdjustmentClass*>(ptr);
}

GType
Gtk::AdjustmentClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_ADJUSTMENT);
	}
	return type;
}

void*
Gtk::AdjustmentClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::AdjustmentClass::changed_proxy(GtkAdjustment *adjustment)
{
	void *ptr = g_object_get_qdata((GObject*)adjustment, G::ObjectSignals::quark());
	if (ptr)
		static_cast<AdjustmentSignals*>(ptr)->on_changed();
	else
	{
		GtkAdjustmentClass *g_class = AdjustmentClass::get_parent_class(adjustment);
		if (g_class->changed)
			g_class->changed(adjustment);
	}
}

void
Gtk::AdjustmentClass::value_changed_proxy(GtkAdjustment *adjustment)
{
	void *ptr = g_object_get_qdata((GObject*)adjustment, G::ObjectSignals::quark());
	if (ptr)
		static_cast<AdjustmentSignals*>(ptr)->on_value_changed();
	else
	{
		GtkAdjustmentClass *g_class = AdjustmentClass::get_parent_class(adjustment);
		if (g_class->value_changed)
			g_class->value_changed(adjustment);
	}
}

