/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  button.cc - GtkButton C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "button.hh"
#include "alignment.hh"
#include "box.hh"
#include "image.hh"
#include "label.hh"
#include "stockid.hh"
#include "private/buttonclass.hh"
#include "private/marshal.hh"

using namespace GFC;

/*  Gtk::Button
 */

Gtk::Button::Button(GtkButton *button, bool owns_reference)
: Bin((GtkBin*)button, owns_reference)
{
}

Gtk::Button::Button() 
: Bin((GtkBin*)ButtonClass::create())
{
}

Gtk::Button::Button(Image& image)
: Bin((GtkBin*)ButtonClass::create())
{
	add(image);
	image.show();
}

Gtk::Button::Button(const char *label, bool use_underline)
: Bin((GtkBin*)ButtonClass::create())
{
	set_label(label);
	set_use_underline(use_underline);
}

Gtk::Button::Button(const String& label, bool use_underline)
: Bin((GtkBin*)ButtonClass::create())
{
	set_label(label);
	set_use_underline(use_underline);
}

Gtk::Button::Button(Image& image, const char *label, bool use_underline, bool horizontal)
: Bin((GtkBin*)ButtonClass::create())
{
	set_image(image, label, use_underline, horizontal);
}

Gtk::Button::Button(Image& image, const String& label, bool use_underline, bool horizontal)
: Bin((GtkBin*)ButtonClass::create())
{
	set_image(image, label, use_underline, horizontal);
}

Gtk::Button::Button(const StockId& stock_id)
: Bin((GtkBin*)ButtonClass::create())
{
	set_stock_id(stock_id);
}

Gtk::Button::~Button()
{
}

String
GFC::Gtk::Button::get_label() const
{
	return gtk_button_get_label(gtk_button());
}

void
Gtk::Button::set_label(const String& label)
{
	gtk_button_set_label(gtk_button(), label.c_str());
}

void 
Gtk::Button::set_stock_id(const StockId& stock_id)
{
	gtk_button_set_label(gtk_button(), stock_id);
	set_use_stock(true);
	set_use_underline(true);
}	

void
Gtk::Button::set_image(Image& image, const String& label, bool use_underline, bool horizontal)
{
	if (gtk_button()->label_text)
		g_free(gtk_button()->label_text);

	Gtk::Widget *child = get_child();
	if (child)
		remove(*child);

	Gtk::Box *box;
	if (horizontal)
		box = new Gtk::HBox(false, 2);
	else
		box = new Gtk::VBox;

	box->pack_start(image, false, false);
	Gtk::Label *label_widget = new Gtk::Label(label, use_underline);
	if (use_underline)
		label_widget->set_mnemonic_widget(this);
	box->pack_end(*label_widget, false, false);

	Gtk::Alignment *align = new Gtk::Alignment(0.5, 0.5);
	add(*align);
	align->add(*box);
	align->show_all();
}

/*  Gtk::Button signals
 */

const Gtk::Button::PressedSignalType Gtk::Button::pressed_signal("pressed", (GCallback)&G::Marshal::void_callback);

const Gtk::Button::ReleasedSignalType Gtk::Button::released_signal("released", (GCallback)&G::Marshal::void_callback);

const Gtk::Button::ClickedSignalType Gtk::Button::clicked_signal("clicked", (GCallback)&G::Marshal::void_callback);

const Gtk::Button::EnterSignalType Gtk::Button::enter_signal("enter", (GCallback)&G::Marshal::void_callback);

const Gtk::Button::LeaveSignalType Gtk::Button::leave_signal("leave", (GCallback)&G::Marshal::void_callback);

const Gtk::Button::ActivateSignalType Gtk::Button::activate_signal("activate", (GCallback)&G::Marshal::void_callback);

