/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  checkmenuitemsignals.cc - Gtk::CheckMenuItem virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "checkmenuitem.hh"
#include "checkmenuitemsignals.hh"
#include "private/checkmenuitemclass.hh"

using namespace GFC;

/*  Gtk::CheckMenuItemSignals
 */

Gtk::CheckMenuItemSignals::CheckMenuItemSignals(CheckMenuItem *check_menu_item)
: MenuItemSignals(check_menu_item)
{
	Gtk::CheckMenuItemClass::init(GTK_CHECK_MENU_ITEM_GET_CLASS(check_menu_item->gtk_check_menu_item()));
}

Gtk::CheckMenuItemSignals::~CheckMenuItemSignals()
{
}

void
Gtk::CheckMenuItemSignals::on_toggled()
{
	GtkCheckMenuItemClass *g_class = CheckMenuItemClass::get_parent_class(instance_);
	if (g_class->toggled)
		g_class->toggled((GtkCheckMenuItem*)instance_);
}

/*  Gtk::CheckMenuItemClass
 */

void
Gtk::CheckMenuItemClass::init(GtkCheckMenuItemClass *g_class)
{
	g_class->toggled = &toggled_proxy;
}

GtkCheckMenuItemClass*
Gtk::CheckMenuItemClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_CHECK_MENU_ITEM_GET_CLASS(instance));
	return static_cast<GtkCheckMenuItemClass*>(ptr);
}

GType
Gtk::CheckMenuItemClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_CHECK_MENU_ITEM);
	}
	return type;
}

void*
Gtk::CheckMenuItemClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::CheckMenuItemClass::toggled_proxy(GtkCheckMenuItem *check_menu_item)
{
	void *ptr = g_object_get_qdata((GObject*)check_menu_item, G::ObjectSignals::quark());
	if (ptr)
		static_cast<CheckMenuItemSignals*>(ptr)->on_toggled();
	else
	{
		GtkCheckMenuItemClass *g_class = CheckMenuItemClass::get_parent_class(check_menu_item);
		if (g_class->toggled)
			g_class->toggled(check_menu_item);
	}
}

