/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  editable.cc - GtkEditable C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "editable.hh"
#include "private/marshal.hh"

using namespace GFC;

/*  Gtk::Editable
 */

Gtk::Editable::Editable()
{
}
	
Gtk::Editable::~Editable()
{
}
	
String
Gtk::Editable::get_chars(int start_pos, int end_pos) const
{
	return gtk_editable_get_chars(gtk_editable(), start_pos, end_pos);
}

void
Gtk::Editable::insert_text(const String& new_text, int& position)
{
	gtk_editable_insert_text(gtk_editable(), new_text.c_str(), new_text.size(), &position);
}

/*  Gtk::Editable Signals
 */

const Gtk::Editable::InsertTextSignalType Gtk::Editable::insert_text_signal("insert_text", (GCallback)&Marshal::void_string_int_pint_callback);

const Gtk::Editable::DeleteTextSignalType Gtk::Editable::delete_text_signal("delete_text", (GCallback)&G::Marshal::void_int_int_callback);

const Gtk::Editable::ChangedSignalType Gtk::Editable::changed_signal("changed", (GCallback)&G::Marshal::void_callback);

