/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  liststore.inl - Gtk::ListStore inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkListStore*
GFC::Gtk::ListStore::gtk_list_store() const
{
	return reinterpret_cast<GtkListStore*>(instance_);
}

inline GFC::Gtk::ListStore::operator GtkListStore* () const
{
	return this ? gtk_list_store() : 0;
}

inline void
GFC::Gtk::ListStore::clear()
{
	gtk_list_store_clear(gtk_list_store());
}

inline void
GFC::Gtk::ListStore::reorder(int *new_order)
{
	gtk_list_store_reorder(gtk_list_store(), new_order);
}

template<typename DataType>
inline void
GFC::Gtk::ListStore::set_value(const TreeIter& iter, int column, const DataType& data)
{
	G::Value value(gtk_list_store()->column_headers[column]);
	value.set(data);
	gtk_list_store_set_value(gtk_list_store(), iter, column, value.g_value());
}

template<typename DataType>
inline void
GFC::Gtk::ListStore::set_enum(const TreeIter& iter, int column, const DataType& data)
{
	G::Value value(gtk_list_store()->column_headers[column]);
	value.set((int)data);
	gtk_list_store_set_value(gtk_list_store(), iter, column, value.g_value());
}

template<typename DataType>
inline void
GFC::Gtk::ListStore::set_object(const TreeIter& iter, int column, const DataType& data)
{
	G::Value value(gtk_list_store()->column_headers[column]);
	value.set((G::Object*)data);
	gtk_list_store_set_value(gtk_list_store(), iter, column, value.g_value());
}

template<typename DataType>
inline void
GFC::Gtk::ListStore::set_pointer(const TreeIter& iter, int column, const DataType& data)
{
	G::Value value(gtk_list_store()->column_headers[column]);
	value.set((void*)data);
	gtk_list_store_set_value(gtk_list_store(), iter, column, value.g_value());
}

