/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  itemsignals.cc - Gtk::Item virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "item.hh"
#include "itemsignals.hh"
#include "private/itemclass.hh"

using namespace GFC;

/*  Gtk::ItemSignals
 */

Gtk::ItemSignals::ItemSignals(Item *item)
: ContainerSignals(item)
{
	Gtk::ItemClass::init(GTK_ITEM_GET_CLASS(item->gtk_item()));
}

Gtk::ItemSignals::~ItemSignals()
{
}

void
Gtk::ItemSignals::on_select()
{
	GtkItemClass *g_class = ItemClass::get_parent_class(instance_);
	if (g_class->select)
		g_class->select((GtkItem*)instance_);
}

void
Gtk::ItemSignals::on_deselect()
{
	GtkItemClass *g_class = ItemClass::get_parent_class(instance_);
	if (g_class->deselect)
		g_class->deselect((GtkItem*)instance_);
}

void
Gtk::ItemSignals::on_toggle()
{
	GtkItemClass *g_class = ItemClass::get_parent_class(instance_);
	if (g_class->toggle)
		g_class->toggle((GtkItem*)instance_);
}

/*  Gtk::ItemClass
 */

void
Gtk::ItemClass::init(GtkItemClass *g_class)
{
	g_class->select = &select_proxy;
	g_class->deselect = &deselect_proxy;
	g_class->toggle = &toggle_proxy;
}

GtkItemClass*
Gtk::ItemClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_ITEM_GET_CLASS(instance));
	return static_cast<GtkItemClass*>(ptr);
}

GType
Gtk::ItemClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_ITEM);
	}
	return type;
}

void*
Gtk::ItemClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::ItemClass::select_proxy(GtkItem *item)
{
	void *ptr = g_object_get_qdata((GObject*)item, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ItemSignals*>(ptr)->on_select();
	else
	{
		GtkItemClass *g_class = ItemClass::get_parent_class(item);
		if (g_class->select)
			g_class->select(item);
	}
}

void
Gtk::ItemClass::deselect_proxy(GtkItem *item)
{
	void *ptr = g_object_get_qdata((GObject*)item, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ItemSignals*>(ptr)->on_deselect();
	else
	{
		GtkItemClass *g_class = ItemClass::get_parent_class(item);
		if (g_class->deselect)
			g_class->deselect(item);
	}
}

void
Gtk::ItemClass::toggle_proxy(GtkItem *item)
{
	void *ptr = g_object_get_qdata((GObject*)item, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ItemSignals*>(ptr)->on_toggle();
	else
	{
		GtkItemClass *g_class = ItemClass::get_parent_class(item);
		if (g_class->toggle)
			g_class->toggle(item);
	}
}

