/*          gfs_func.c - Necessary functions for gfslicer  -  S.Ekanth      */


#include <gnome.h>


#include "support.h"
#include "interface.h"
#include "gfs_defs.h"
#include "gfs_conf.h"
#include "gfs_func.h"


#include <ctype.h>
#include <stdlib.h>

/*     Function to convert an unsigned long int into gchar* type data      */

gchar* itoa(unsigned long int num)
{
  unsigned long int mod,div;
  int i=0,j=0,len=0;
  gchar *numarr, *retarr;

  numarr = g_malloc0(15);
  retarr = g_malloc0(15);

  while(num != 0)
  {
    mod = num%10;
    div = num/10;
    numarr[i++] = toascii(mod+48);
    num = div;
  }

  len = strlen(numarr);

  for(i=len-1 ; i>=0 ; i--)
    retarr[j++] = numarr[i];

  retarr[j] = '\0';
 
  return retarr;
}




/*                                  FILE SLICE FUNCTION                               */





gboolean file_slice (gchar* sinfile_path, gchar* soutfile_path, gchar* sinput_file,unsigned long int ssize_to_split, unsigned long int snopieces, GtkWidget* sslice)
{

int i = 0, j = 0;
unsigned long int sactual_size, sfor_var, sfile_size = 0, scheck = 0;
gchar *soutput_file, *stemp_name, sfile_num[3], *stemp_out_fpath;
char  sfile_mark[30];
char sbuf;
 
FILE *sinfile, *soutfile;

GtkWidget* swidget;

stemp_out_fpath = g_malloc0 (100);
soutput_file = g_malloc0 (30);
stemp_name = g_malloc0 (30);

if(ssize_to_split<4)
	return 0;

if((sinfile=fopen(sinfile_path,"rb")) == NULL)
{
    swidget = lookup_widget(sslice, "entry16");
    gtk_entry_set_text(GTK_ENTRY(swidget),"Input path seems invalid. Please check...");
    return 0;
}

while (!feof(sinfile))
{
	sbuf=fgetc(sinfile);
	sfile_size++;
}
rewind(sinfile);

while(sinput_file[i]!='.')
{
	if(sinput_file[i]=='\0')
		break;
	soutput_file[i]=sinput_file[i];
	i++;
}

soutput_file[i]='\0';
strcat(soutput_file,".b");
strcpy(stemp_name,soutput_file);
strcpy(stemp_out_fpath,soutfile_path);

strcpy(sfile_mark,sinput_file);
strcat(sfile_mark,"@\0");

i=48;
j=48;
sfile_num[0]=toascii(i);
sfile_num[1]=toascii(j);
sfile_num[2]='\0';

strcat(soutput_file,sfile_num);
strcat(soutfile_path,soutput_file);

if((soutfile=fopen(soutfile_path,"wb+")) == NULL)
{
    swidget = lookup_widget(sslice, "entry16");
    gtk_entry_set_text(GTK_ENTRY(swidget),"Output path seems invalid. Please check...");
    return 0; 
}
fwrite(sfile_mark,sizeof(sfile_mark),1,soutfile);
fprintf(soutfile,"%ld\n",sfile_size);
fprintf(soutfile,"%ld\n",snopieces);
sactual_size=ssize_to_split*1024;

while(!feof(sinfile))
{
	for(sfor_var=1;sfor_var<=sactual_size;sfor_var++)
	{
		if(!(feof(sinfile))&&(scheck<(sfile_size-1)))
		{
			sbuf=fgetc(sinfile);
			fputc(sbuf,soutfile);
			scheck++;
		}
		else
		{
			fclose(soutfile);
			fclose(sinfile);
			j++;

			return 1;
		}
	}

	fclose(soutfile);
	strcpy(soutput_file,stemp_name);
        strcpy(soutfile_path,stemp_out_fpath);
	j++;

	if(j>57)
	{
		i++;
		j=48;
	}

	sfile_num[0]=toascii(i);
	sfile_num[1]=toascii(j);
	sfile_num[2]='\0';
	strcat(soutput_file,sfile_num);
        strcat(soutfile_path,soutput_file);
	soutfile=fopen(soutfile_path,"wb+");
}

fclose(sinfile);
fclose(soutfile);
j++;

return 1;
}




/*                                  FILE DESLICE FUNCTION                              */




gboolean file_deslice (gchar *dinfile_path, gchar *doutfile_path, GtkWidget *ddeslice)
{

int i=0,j=0;
unsigned long int doutfile_size=0,dcheck_out=0,dinfile_size=0,dcheck_in=0, dnopieces;
gchar *dinput_file, dfile_num[3], dfile_mark[30], *doutput_file;
char dbuf;
FILE *dinfile,*doutfile;

GtkWidget *dwidget;

dinput_file = g_malloc0 (100);
doutput_file = g_malloc0 (100);

strcpy(dinput_file, dinfile_path);

strcat (dinput_file, ".b");
strcat (dinput_file, "00");

if((dinfile = fopen (dinput_file, "rb")) == NULL)
{
    dwidget = lookup_widget(ddeslice, "entry17");
    gtk_entry_set_text(GTK_ENTRY(dwidget),"Input path seems invalid. Please check...");
    return 0;
}
 
fread (dfile_mark,sizeof (dfile_mark), 1, dinfile);
fscanf (dinfile, "%ld", &doutfile_size);
dbuf = fgetc(dinfile);
fscanf (dinfile, "%ld", &dnopieces);
dbuf = fgetc (dinfile);

while(!feof(dinfile))
{
	dbuf=fgetc(dinfile);
	dinfile_size++;
}

rewind(dinfile);
fread(dfile_mark,sizeof(dfile_mark),1,dinfile);
fscanf(dinfile,"%ld",&doutfile_size);
dbuf=fgetc(dinfile);
fscanf (dinfile, "%ld", &dnopieces);
dbuf = fgetc (dinfile);

i=0;
while(dfile_mark[i]!='@')
{
	doutput_file[i]=dfile_mark[i];
	i++;
}

if (i > 0)
  doutput_file[i]='\0';

if((doutfile=fopen(doutfile_path,"wb+")) == NULL)
{
    dwidget = lookup_widget(ddeslice, "entry17");
    gtk_entry_set_text(GTK_ENTRY(dwidget),"Output path seems invalid. Please check...");
    return 0;
}
i=48;
j=48;

do
{
	if(dinfile_size==0)
	{
		while(!feof(dinfile))
		{
			dbuf=fgetc(dinfile);
			dinfile_size++;
		}
	rewind(dinfile);
	}

	while(!(feof(dinfile))&&(dcheck_out<doutfile_size)&&(dcheck_in<dinfile_size-1))
	{
		dbuf=fgetc(dinfile);
		fputc(dbuf,doutfile);
		dcheck_out++;
		dcheck_in++;
	}

	dcheck_in=0;
	dinfile_size=0;
	fclose(dinfile);
	strcpy(dinput_file,dinfile_path);
	j++;

	if(j>57)
	{
		i++;
		j=48;
	}

	dfile_num[0]=toascii(i);
	dfile_num[1]=toascii(j);
	dfile_num[2]='\0';
        strcat(dinput_file,".b");
	strcat(dinput_file,dfile_num);
}while((dinfile=fopen(dinput_file,"rb"))!=NULL);

fclose(doutfile);

return 1;

}


/*                            WRITE LOG FUNCTION                         */

void gfs_show_log (GtkWidget* widget)
{

  GtkWidget* ltext;

  FILE *logfp;
  char* lfname;
  gchar* text;

  lfname = g_malloc (100);
  text = g_malloc (500);

  strcpy(lfname, prefs.dir.logdir);
  strcat(lfname, "log.txt");
  
  if((logfp=fopen(lfname,"r")) == NULL)
    return;
    
  ltext = lookup_widget (widget, "text2"); 

  while(!feof(logfp))
  {
    fgets(text, 100, logfp);
    gtk_text_insert (GTK_TEXT (ltext), NULL, NULL, NULL, text, strlen(text));
  }


}