
/* -----------------------------------------------------------------------------
 * $Id: Bytecodes.h,v 1.8 2001/08/09 11:19:16 sewardj Exp $
 *
 * (c) The GHC Team, 1998-2000
 *
 * Bytecode definitions.
 *
 * ---------------------------------------------------------------------------*/

/* --------------------------------------------------------------------------
 * Instructions
 *
 * Notes:
 * o CASEFAIL is generated by the compiler whenever it tests an "irrefutable"
 *   pattern which fails.  If we don't see too many of these, we could
 *   optimise out the redundant test.
 * ------------------------------------------------------------------------*/

/* NOTE:

   THIS FILE IS INCLUDED IN HASKELL SOURCES (ghc/compiler/ghci/ByteCodeGen.lhs).
   DO NOT PUT C-SPECIFIC STUFF IN HERE!

   I hope that's clear :-)
*/

#define bci_ARGCHECK  1
#define bci_PUSH_L    2
#define bci_PUSH_LL   3
#define bci_PUSH_LLL  4
#define bci_PUSH_G    5
#define bci_PUSH_AS   6
#define bci_PUSH_UBX  7
#define bci_PUSH_TAG  8
#define bci_SLIDE     9
#define bci_ALLOC     10
#define bci_MKAP      11
#define bci_UNPACK    12
#define bci_UPK_TAG   13
#define bci_PACK      14
#define bci_TESTLT_I  15 
#define bci_TESTEQ_I  16
#define bci_TESTLT_F  17
#define bci_TESTEQ_F  18
#define bci_TESTLT_D  19
#define bci_TESTEQ_D  20
#define bci_TESTLT_P  21
#define bci_TESTEQ_P  22
#define bci_CASEFAIL  23
#define bci_ENTER     24
#define bci_RETURN    25
#define bci_STKCHECK  26
#define bci_JMP       27
#define bci_CCALL     28
#define bci_SWIZZLE   29

/* If a BCO definitely requires less than this many words of stack,
   don't include an explicit STKCHECK insn in it.  The interpreter
   will check for this many words of stack before running each BCO,
   rendering an explicit check unnecessary in the majority of
   cases. */
#define INTERP_STACK_CHECK_THRESH  50

/*-------------------------------------------------------------------------*/
