with Iirs; use Iirs;
with Ortho_Nodes;
with Ortho_Ident; use Ortho_Ident;
with Types; use Types;

package Translation is
   --  Initialize the package: create internal nodes.
   procedure Initialize;

   --  Translate (generate code) for design unit UNIT.
   --  If MAIN is true, the unit is really the unit being compiled (not an
   --  external unit).  Code shouldn't be generated for external units.
   procedure Translate (Unit : Iir_Design_Unit; Main : Boolean);

   --  Translate std.standard.
   procedure Translate_Standard (Main : Boolean);

   --  Get the ortho node for subprogram declaration DECL.
   function Get_Ortho_Decl (Subprg : Iir) return Ortho_Nodes.O_Dnode;

   package Chap12 is
      --  Primary unit + secondary unit (architecture name which may be null)
      --  to elaborate.
      procedure Elaborate (Primary : String;
                           Secondary : String;
                           Filelist : String;
                           Whole : Boolean);
   end Chap12;

   --  If set, generate Run-Time Information nodes.
   Flag_Rti : Boolean := True;

   --  If set, do not generate 64 bits integer types and operations.
   Flag_Only_32b : Boolean := False;

   --  If set, do not generate code for unused subprograms.
   --  Be careful: unless you are in whole compilation mode, this
   --  flag shouldn't be set for packages and entities.
   Flag_Discard_Unused : Boolean := False;

   --  If set, do not generate code for unused implicit subprograms.
   Flag_Discard_Unused_Implicit : Boolean := False;

   type Foreign_Kind_Type is (Foreign_Unknown,
                              Foreign_Vhpidirect,
                              Foreign_Intrinsic);

   type Foreign_Info_Type (Kind : Foreign_Kind_Type := Foreign_Unknown)
   is record
      Subprg : O_Ident;

      case Kind is
         when Foreign_Unknown =>
            null;
         when Foreign_Vhpidirect =>
            Lib : Name_Id;
         when Foreign_Intrinsic =>
            null;
      end case;
   end record;

   Foreign_Bad : constant Foreign_Info_Type := (Kind => Foreign_Unknown,
                                                Subprg => O_Ident_Nul);

   --  Return a foreign_info for DECL.
   --  Can generate error messages, if the attribute expression is ill-formed.
   --  If EXTRACT_NAME is set, internal fields of foreign_info are set.
   --  Otherwise, only KIND discriminent is set.
   --  EXTRACT_NAME should be set only inside translation itself, since the
   --  name can be based on the prefix.
   function Translate_Foreign_Id (Decl : Iir; Extract_Name : Boolean)
                                 return Foreign_Info_Type;

end Translation;
