// CUSTOM_CAMERA.H : an extended ogl_camera class.

// Copyright (C) 2006 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#ifndef CUSTOM_CAMERA_H
#define CUSTOM_CAMERA_H

class ghemical_camera;

/*################################################################################################*/

#include <ghemical/typedef.h>
#include <oglappth/ogl_camera.h>

#include "project.h"

/*################################################################################################*/

class custom_camera :
	public ogl_camera
{
	protected:
	
	project * prj;
	
	int ccam_index;
	int wcl_counter;
	
	static int ccam_counter;
	
	friend class oglview_wcl;
	friend class custom_app;
	
	public:
	
	custom_camera(const ogl_object_location &, GLfloat, project *);
	~custom_camera(void);
	
	int GetCCamI(void) { return ccam_index; }
};

/*################################################################################################*/

#endif	// CUSTOM_CAMERA_H

// eof
