// RCPVIEW_WCL.H : write a short description here...

// Copyright (C) 2005 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "ghemicalconfig2.h"

#ifndef RCPVIEW_WCL_H
#define RCPVIEW_WCL_H

#include "p1dview_wcl.h"

//#include <ghemical/typedef.h>

/*################################################################################################*/

class rcpview_wcl :
	public p1dview_wcl
{
	protected:
	
	bool ready;
	
	vector<i32u> patoms;
	vector<bond *> rbonds;
	vector<bond *> pbonds;
	
	fGL r_treshold;
	fGL p_treshold;
	
	public:
	
	rcpview_wcl(const char *, const char *);
	virtual ~rcpview_wcl(void);
	
	void AddPAtom(i32u p1) { patoms.push_back(p1); }
	void AddRBond(bond * p1) { rbonds.push_back(p1); }
	void AddPBond(bond * p1) { pbonds.push_back(p1); }
	
	void Finalize(void);		// virtual
	
	void ButtonEvent(int, int);	// virtual
	void MotionEvent(int, int);	// virtual
};

/*################################################################################################*/

#endif	// RCPVIEW_WCL_H

// eof
