/*******************************************************************************
*
*       This file is part of the General Hidden Markov Model Library,
*       GHMM version __VERSION__, see http://ghmm.org
*
*       Filename: ghmm/ghmm/rng.h
*       Authors:  Alexander Schliep, Ben Rich
*
*       Copyright (C) 1998-2004 Alexander Schliep 
*       Copyright (C) 1998-2001 ZAIK/ZPR, Universitaet zu Koeln
*	Copyright (C) 2002-2004 Max-Planck-Institut fuer Molekulare Genetik, 
*                               Berlin
*                                   
*       Contact: schliep@ghmm.org             
*
*       This library is free software; you can redistribute it and/or
*       modify it under the terms of the GNU Library General Public
*       License as published by the Free Software Foundation; either
*       version 2 of the License, or (at your option) any later version.
*
*       This library is distributed in the hope that it will be useful,
*       but WITHOUT ANY WARRANTY; without even the implied warranty of
*       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*       Library General Public License for more details.
*
*       You should have received a copy of the GNU Library General Public
*       License along with this library; if not, write to the Free
*       Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*
*       This file is version $Revision: 2087 $ 
*                       from $Date: 2008-02-28 17:36:54 -0500 (Thu, 28 Feb 2008) $
*             last change by $Author: grunau $.
*
*******************************************************************************/
#ifndef GHMM_RNG_H
#define GHMM_RNG_H

#include "ghmmconfig.h"

/* use mersenne twister as default */
#ifndef GHMM_RNG_BSD
#ifndef GHMM_RNG_GSL
#ifndef GHMM_RNG_MERSENNE_TWISTER
#define GHMM_RNG_MERSENNE_TWISTER
#endif
#endif
#endif


/* ----- Mersenne Twister -------------------------------------------------- */         
#ifdef GHMM_RNG_MERSENNE_TWISTER

typedef char ghmm_rng_state_t;
typedef ghmm_rng_state_t GHMM_RNG;

#endif /* GHMM_RNG_MERSENNE_TWISTER */


/* ----- BSD --------------------------------------------------------------- */
#ifdef GHMM_RNG_BSD

#include <stdlib.h>

typedef char ghmm_rng_state_t[8];
typedef ghmm_rng_state_t GHMM_RNG;

#endif /* GHMM_RNG_BSD */


/* ----- GSL --------------------------------------------------------------- */
#ifdef GHMM_RNG_GSL

#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>

/* Types defined in GSL */
typedef gsl_rng GHMM_RNG;
#endif /* GHMM_RNG_GSL */


/** @name rng Initialization for the random number generator */

/**
 */
extern GHMM_RNG *RNG;


#ifdef __cplusplus
extern "C" {
#endif

/**
 */
  void ghmm_rng_init (void);

/**
 */
  void ghmm_rng_timeseed (GHMM_RNG * r);


/* ----- Mersenne Twister and BSD RNG -------------------------------------- */
#ifdef GHMM_RNG_GSL
/* Functions defined in GSL */
#define GHMM_RNG_SET gsl_rng_set
#define GHMM_RNG_UNIFORM gsl_rng_uniform
#define GHMM_RNG_NAME gsl_rng_name

#else

/* Functions */
#define GHMM_RNG_SET ghmm_rng_set
#define GHMM_RNG_UNIFORM ghmm_rng_uniform
#define GHMM_RNG_NAME ghmm_rng_name

  void ghmm_rng_set (GHMM_RNG * aState, unsigned long int seed);

  double ghmm_rng_uniform (GHMM_RNG * r);

  const char *ghmm_rng_name (GHMM_RNG * r);
#endif /* not GHMM_RNG_GSL */

#ifdef __cplusplus
}
#endif
#endif                          /* GHMM_RNG_H */
