#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <getopt.h>

#include "config.h"

IdentdConf config;

static char *conffile="/etc/gidentd/gidentd.conf";

static void defaultconfig(void)
{
	config.logfile="/var/log/gidentd.log";
	config.pidfile="/var/run/gidentd.pid";
	config.port=113;
	config.forcev4=0;
	config.inetd=0;
}

static void display_help(char *prog)
{
	printf("Usage: %s [-46adhi] [-c configfile] [-l logfile] [-p port]\n", prog);
	printf("-4 --ipv4		: do not use ipv6\n");
	printf("-6 --ipv6		: use ipv6 if available, fallback to ipv4\n");
	printf("-a --auto		: auto detect inetd\n");
	printf("-c --config <file>	: use configfile <file>\n");
	printf("-d --daemon		: force daemon mode\n");
	printf("-h --help		: display this help\n");
	printf("-i --inetd		: force inetd mode\n");
	printf("-l --logfile <file>	: use alternate logfile\n");
	printf("-P --pidfile [file]	: use alternate pidfile, `-' to disable\n");
	printf("-p --port <port>	: listen on port <port>\n");
	printf("\n");
}
	
	
void GetConfig(int argc, char **argv)
{
	struct option long_options[] = {
		{"ipv4", 0, 0, '4'},
		{"ipv6", 0, 0, '6'},
		{"auto", 0, 0, 'a'},
		{"config", 1, 0, 'c'},
		{"daemon", 0, 0, 'd'},
		{"help", 0, 0, 'h'},
		{"inetd", 0, 0, 'i'},
		{"logfile", 1, 0, 'l'},
		{"pidfile", 1, 0, 'P'},
		{"port", 1, 0, 'p'},
		{0, 0, 0, 0}
	};
	int option_index;
	int c;
	
	defaultconfig();
	
	opterr=0;
	while((c=getopt_long(argc, argv, "46acdhil:P:p:", long_options, &option_index))>=0) {
		switch(c) {
		case '4':
			config.forcev4=1;
			break;

		case '6':
			config.forcev4=0;
			break;

		case 'a':
			config.inetd=0;
			break;

		case 'c':
			conffile=optarg;
			break;

		case 'd':
			config.inetd=2;
			break;
			
		case 'h':
			display_help(argv[0]);
			exit(0);

		case 'i':
			config.inetd=1;
			break;

		case 'l':
			config.logfile=optarg;
			break;

		case 'P':
			config.pidfile=strcmp("-",optarg)?optarg:NULL;
			break;

		case 'p':
			config.port=atoi(optarg);
			break;

		case '?':
			display_help(argv[0]);
			exit(0);
		}
			
	}
}
	
