/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GIMAGEVIEW_H__
#define __GIMAGEVIEW_H__

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>

#include "intl.h"

/* global constants */
#define PROG_NAME     "GImageView"
#define PROG_VERSION  "GImageView Version "VERSION
#define PROG_AUTHOR   "Takuro Ashie"
#define PROG_ADDRESS  "ashie@homa.ne.jp"
#define PROG_URI      "http://www.homa.ne.jp/~ashie/gimageview/"
#define RC_DIR        ".gimv"
#define GIMAGEVIEW_RC "gimvrc"
#define GTK_RC "gtkrc"
#define KEYCONF_RC    "keyconf"
#define BUF_SIZE      4096
#define MAX_PATH_LEN  1024

/* type defs */
typedef struct ImageInfo_Tag   ImageInfo;
typedef struct ImageWindow_Tag ImageWindow;
typedef struct ImageView_Tag   ImageView;
typedef struct ThumbWindow_Tag ThumbWindow;
typedef struct ThumbView_Tag   ThumbView;
typedef struct Thumbnail_Tag   Thumbnail;
typedef struct DirView_Tag     DirView;
typedef struct OpenFiles_Tag   OpenFiles;

typedef struct GlobValue_Tag {
   gboolean startup_exec_slideshow;
} GlobValue;

typedef enum
{
   MODULE_UNKNOWN,
   MODULE_IMGVIEW,
   MODULE_IMGWIN,
   MODULE_THUMBVIEW,
   MODULE_DIRVIEW,
   MODULE_THUMBWIN
} GimvModuleType;

void gimageview_quit ();

#endif /* __GIMAGEVIEW_H__ */
