/*
*  
*  $Id: integration.h 4630 2012-01-30 13:52:19Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once

#include <api/imodelointegracion.h>
#include <yasper/yasper.h>

namespace GNC {
	namespace GCS {
		namespace Eventos {

			class EXTAPI HL7SendRequestEvent : public GNC::GCS::Eventos::IEvento
			{
			private:
				std::string m_Message;

			public:
				HL7SendRequestEvent() : GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_HL7SendRequest, 0, 100, NULL)
				{
					m_Nombre = "HL7SendRequest";					
				}

				HL7SendRequestEvent(const std::string& msg): GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_HL7SendRequest, 0, 100, NULL){
					this->m_Nombre  = "HL7SendRequest";
					this->m_Message = msg;

				}

				~HL7SendRequestEvent()
				{
				}

				const std::string& GetMessage() const
				{
					return m_Message;
				}

				virtual void pushInfo(std::ostream& out) const {
					out << "HL7SendRequest ()";
				}
			};

			class EXTAPI IntegrationEvent : public GNC::GCS::Eventos::IEvento
			{
			private:
				GnkPtr<GIL::IModeloIntegracion> m_apIntegrationModel;

			public:
				IntegrationEvent() : GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_Integration, 0, 100, NULL)
				{
					m_Nombre = "Integration";					
				}

				IntegrationEvent(const GnkPtr<GIL::IModeloIntegracion>& IntegrationModel): GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_Integration, 0, 100, NULL){
					this->m_Nombre           = "Integration";
					this->m_apIntegrationModel = IntegrationModel;					
				}

				~IntegrationEvent()
				{
				}

				const GnkPtr<GIL::IModeloIntegracion>& GetIntegrationModel()
				{
					return m_apIntegrationModel;
				}

				virtual void pushInfo(std::ostream& out) const {
					out << "Integration ()";
				}
			};
		}
	}
}
