/*
 *  
 *  $Id: editordicom.cpp 4503 2012-01-10 09:55:40Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <wx/string.h>
#include <main/controllers/configurationcontroller.h>

#include "editordicom.h"

#include <api/globals.h>
#include <api/ientorno.h>
#include <api/ivista.h>
#include <api/icontextoestudio.h>

#include <api/dicom/idicommanager.h>

#include <export/icontratoscore.h>

namespace GNC {
	namespace GUI {

		EditorDICOM::EditorDICOM(wxWindow* pParent,std::string pathActivo, GIL::DICOM::IPACSController* pImportacion):EditorDICOMBase(pParent)
		{
			m_ruta = pathActivo;

			//se cargan los tags dicom del dicom activo

			GIL::DICOM::IDICOMManager*	pDICOMManager= pImportacion->CrearInstanciaDeDICOMManager();
			
			pDICOMManager->CargarFichero(pathActivo, m_base);

			int i=0;
			for(GIL::DICOM::ListaTags::iterator it = m_base.tags.begin(); it!= m_base.tags.end(); it++){
				wxString helpString = wxString::FromUTF8(pDICOMManager->GetDescription((*it).first).c_str());
				wxStringProperty* prop = NULL;
				if(helpString.size()>0){
					prop = new wxStringProperty(helpString,
						wxPG_LABEL,wxString::FromUTF8((*it).second.c_str()));
				}else{
					prop = new wxStringProperty(wxString::FromUTF8((*it).first.c_str()),
						wxPG_LABEL,wxString::FromUTF8((*it).second.c_str()));
				}
				prop->SetHelpString(wxString::FromUTF8((*it).first.c_str()));
				m_pListaAtributos->Append(prop);
				i++;
			}

			pImportacion->LiberarInstanciaDeDICOMManager(pDICOMManager);

			std::string strTmp;
			GNC::GCS::ConfigurationController::Instance()->readStringGeneral("/GinkgoCore/Exportacion", "ValorDefectoAnonimizacion", strTmp);
			m_valorAnonimizado = wxString::FromUTF8(strTmp.c_str());

			//por defecto el check de configuracion esta checkeado

			m_pListaAtributos->Refresh(false);
			Layout();

			m_pListaAtributos->Connect(wxEVT_PG_CHANGED,wxPropertyGridEventHandler(EditorDICOM::OnPropertyChanged),NULL,this);
			m_pListaAtributos->Connect(wxEVT_PG_DOUBLE_CLICK,wxPropertyGridEventHandler(EditorDICOM::OnPropertyDobleClick),NULL,this);			
		}


		EditorDICOM::EditorDICOM(wxWindow* pParent,GIL::DICOM::TipoJerarquia& base, GIL::DICOM::IPACSController* pImportacion):EditorDICOMBase(pParent)
		{
			//se cargan los tags dicom del dicom activo

			GIL::DICOM::IDICOMManager*	pDICOMManager= pImportacion->CrearInstanciaDeDICOMManager();
			
			m_base = base;
			int i=0;
			for(GIL::DICOM::ListaTags::iterator it = m_base.tags.begin(); it!= m_base.tags.end(); it++){
				wxString helpString = wxString::FromUTF8(pDICOMManager->GetDescription((*it).first).c_str());
				wxStringProperty* prop = NULL;
				if(helpString.size()>0){
					prop = new wxStringProperty(helpString,
						wxPG_LABEL,wxString::FromUTF8((*it).second.c_str()));
				}else{
					prop = new wxStringProperty(wxString::FromUTF8((*it).first.c_str()),
						wxPG_LABEL,wxString::FromUTF8((*it).second.c_str()));
				}
				prop->SetHelpString(wxString::FromUTF8((*it).first.c_str()));
				m_pListaAtributos->Append(prop);
				i++;
			}

			pImportacion->LiberarInstanciaDeDICOMManager(pDICOMManager);

			std::string strTmp;
			GNC::GCS::ConfigurationController::Instance()->readStringGeneral("/GinkgoCore/Exportacion", "ValorDefectoAnonimizacion", strTmp);

			GNC::GCS::ConfigurationController::Instance()->readStringGeneral("/GinkgoCore/Exportacion", "ValorDefectoAnonimizacion", strTmp);
			m_valorAnonimizado = wxString::FromUTF8(strTmp.c_str());

			//por defecto el check de configuracion esta checkeado

			m_pListaAtributos->Refresh(false);
			Layout();

			m_pListaAtributos->Connect(wxEVT_PG_CHANGED,wxPropertyGridEventHandler(EditorDICOM::OnPropertyChanged),NULL,this);
			m_pListaAtributos->Connect(wxEVT_PG_DOUBLE_CLICK,wxPropertyGridEventHandler(EditorDICOM::OnPropertyDobleClick),NULL,this);			
		}

		EditorDICOM::~EditorDICOM()
		{
			m_pListaAtributos->Disconnect(wxEVT_PG_CHANGED,wxPropertyGridEventHandler(EditorDICOM::OnPropertyChanged),NULL,this);
			m_pListaAtributos->Disconnect(wxEVT_PG_DOUBLE_CLICK,wxPropertyGridEventHandler(EditorDICOM::OnPropertyDobleClick),NULL,this);		
		}

		void EditorDICOM::GetTagsEditados(GIL::DICOM::TipoJerarquia & base)
		{
			base.tags.clear();
			for(wxPGProperty* it=m_pListaAtributos->GetFirst();it!=NULL;it=m_pListaAtributos->GetNextSiblingProperty(it)){
				if(it->IsFlagSet(wxPG_PROP_MODIFIED)){
					std::string clave(it->GetHelpString().ToUTF8());
					std::string valor(it->GetValueAsString().ToUTF8());
					base.tags[clave] = valor;
				}
			}			
		}

		void EditorDICOM::OnCheckAnonimizar(wxCommandEvent &){
			if(m_pCheckAnonimizar->GetValue()){
				m_pPanelCampos->Show(m_pCheckAnonimizar->GetValue());
				m_pCheckConfiguracion->SetValue(true);
				wxCommandEvent evt;
				OnCheckConfiguracion(evt);
			} else {
				m_pPanelCampos->Show(false);
			}			
			Layout();
		}

		void EditorDICOM::OnCheckNombreApellidos(wxCommandEvent &){
			//se anonimiza 0010|0010 (nombre del paciente)
			std::string clave("0010|0010");
			Anonimizar(clave,m_pCheckNombrePaciente->IsChecked());
		}

		void EditorDICOM::OnCheckIdPaciente(wxCommandEvent &){
			//se anonimiza 0010|0020" (id del paciente)
			std::string clave("0010|0020");
			Anonimizar(clave,m_pCheckIdPaciente->IsChecked());
		}

		void EditorDICOM::OnCheckInstituciones(wxCommandEvent &){
			//se anonimiza (0008,0080) Institution Name
			std::string clave("0008|0080");
			Anonimizar(clave,m_pCheckInstituciones->IsChecked());
		}

		void EditorDICOM::OnCheckComentarios(wxCommandEvent &){
			//descripcion del estudio, serie e imagenes
			//estudio
			{
				std::string clave("0008|1030");
				Anonimizar(clave,m_pCheckComentarios->IsChecked());
			}
			//serie
			{
				std::string clave("0008|103e");
				Anonimizar(clave,m_pCheckComentarios->IsChecked());
			}
			//imagen
			{
				std::string clave("0020|4000");
				Anonimizar(clave,m_pCheckComentarios->IsChecked());
			}
		}

		void EditorDICOM::OnCheckConfiguracion(wxCommandEvent &){
	/*	TODO	//se cargan los tags y se anonimizan...
			wxConfigBase * config = wxConfigBase::Get();
			//se actualiza el fichero de configuracion
			config->SetPath(wxT("/GinkgoCore/Exportacion/TagsAnonimizacion"));
			wxString str;
			long dummy;

			bool bCont = config->GetFirstGroup(str, dummy);
			while ( bCont ) {
				config->SetPath(str);
				wxString grupo;
				wxString elemento;
				config->Read(wxT("Grupo"),&grupo,wxEmptyString);
				config->Read(wxT("Elemento"),&elemento,wxEmptyString);

				wxString wxClave = grupo + wxT("|") + elemento;
				std::string clave(wxClave.ToUTF8());

				if(clave == std::string("0010|0010")){
					m_pCheckNombrePaciente->SetValue(m_pCheckConfiguracion->IsChecked());
				}else if(clave == std::string("0010|0020")){
					m_pCheckIdPaciente->SetValue(m_pCheckConfiguracion->IsChecked());
				} else if(clave == std::string("0008|0080")){
					m_pCheckIdPaciente->SetValue(m_pCheckInstituciones->IsChecked());
				}

				Anonimizar(clave,m_pCheckConfiguracion->IsChecked());

				config->SetPath(wxT(".."));
				bCont = config->GetNextGroup(str, dummy);
			}
*/
		}

		void EditorDICOM::Anonimizar(std::string& clave, bool anonimizar)
		{
			wxString value = m_valorAnonimizado;

			if(!anonimizar){
				std::string tmp;
				if(m_base.getTag(clave,tmp)){
					value = wxString::FromUTF8(tmp.c_str());
				}
			}

			for(wxPGProperty* it=m_pListaAtributos->GetFirst();it!=NULL;it=m_pListaAtributos->GetNextSiblingProperty(it)){
				if(it->GetHelpString() == wxString::FromUTF8(clave.c_str())){
					it->SetValueFromString(value);
					if(anonimizar){
						m_pListaAtributos->SetPropertyCell(it->GetId(),0,it->GetLabel(),wxNullBitmap,*wxWHITE,*wxRED);
						m_pListaAtributos->SetPropertyCell(it->GetId(),1,it->GetValue(),wxNullBitmap,*wxWHITE,*wxRED);
					}else{
						m_pListaAtributos->SetPropertyCell(it->GetId(),0,it->GetLabel());
						m_pListaAtributos->SetPropertyCell(it->GetId(),1,it->GetValue());
					}
					it->ChangeFlag(wxPG_PROP_MODIFIED,anonimizar);
					m_pListaAtributos->RefreshProperty(it);
					return;
				}
			}
		}

		void EditorDICOM::OnPropertyChanged(wxPropertyGridEvent& event) {
			wxPGProperty* selected= event.GetProperty();
			m_pListaAtributos->SetPropertyCell(selected->GetId(),0,selected->GetLabel(),wxNullBitmap,*wxWHITE,*wxRED);
			m_pListaAtributos->SetPropertyCell(selected->GetId(),1,selected->GetValue(),wxNullBitmap,*wxWHITE,*wxRED);
		}

		void EditorDICOM::OnPropertyDobleClick(wxPropertyGridEvent& event){
			std::string clave(event.GetProperty()->GetHelpString().ToUTF8());
			Anonimizar(clave,!event.GetProperty()->IsFlagSet(wxPG_PROP_MODIFIED));
		}
	};

};
