/*
 *  
 *  $Id: panelestudio.h 4742 2012-02-23 10:57:03Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include "panelhistorial2base.h"
#include "panelserie.h"
#include <map>
#include <main/controllers/controladorhistorial.h>

namespace GNC {
	namespace GUI {
		class PanelEstudio: public PanelEstudioBase,public INodoHistorial, public ISeleccionableHistorial {
		public:
			PanelEstudio(INodoHistorial* pPadre, wxWindow* pParentWindow, const std::string& descripcion, const std::string& uidEstudio);
			~PanelEstudio();
			void Seleccionar(bool seleccionar,bool force=false);
			void InitFields(const std::string& descripcion);
			
			PanelSerie* GetSerie(const GNC::GCS::ControladorHistorial::ModeloSerie& modeloSerie);
			virtual void OnPaint(wxPaintEvent &event);
			void OnSize(wxSizeEvent& event);
			void OnMouseSeleccionar(wxMouseEvent& event);
			void OnMenuMouse(wxMouseEvent& event);
			virtual void OnMouseWheel(wxMouseEvent& event);
			void OnEliminar(wxCommandEvent& event);
			void OnLimpiarHistorial(wxCommandEvent &event);
			void OnUploadPACS(wxCommandEvent &event);
			void Detach(wxWindow* pHijo);
			void Eliminar();
			void OnAbrir(wxCommandEvent& event);

		protected:
		};
	}
}


