/*
 *  
 *  $Id: panelhistorial2.h 4501 2011-12-20 11:13:41Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <map>
#include <list>

#include "ipanelhistorial.h"
#include "panelhistorial2base.h"

#include <api/ivista.h>
#include <main/controllers/controladorhistorial.h>
#include <main/controllers/controladoreventos.h>

#include <wx/scrolwin.h>
#include <wx/datectrl.h>
#include <wx/dateevt.h>

class IControladorModulo;
class PanelPreview;
class wxBitmapComboBox;
class SubTitledPanel;

namespace GNC {
	namespace GUI {
		class TimerRecargarHistorial;
		class PanelSerie;
		class PanelPaciente;
		
		class PanelHistorial2 : public PanelHistorial2Base , public IPanelHistorial, public GNC::GCS::IObservador, public INodoHistorial {

		public:

			PanelHistorial2(wxWindow* parent);
			~PanelHistorial2();

			void RecargarCombos(bool comprobarPurga);

//region "Interfaz Ihistorial"

			void CargarSeries( const GNC::GCS::IControladorHistorial::ListaModelosSeries& modelos, GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion);

			void CargarDCMs( const GNC::GCS::IControladorHistorial::ListaModelosDCM& modelos, GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion, bool desplegarNodo = false);

		/*	void CargarDICOM( const std::vector<std::string>& paths, bool abrirDespuesDeCargar)
			{
				CargarDICOM( paths, abrirDespuesDeCargar, NULL);
			}

			void CargarDICOM( const std::vector<std::string>& paths, bool abrirDespuesDeCargar, GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion);*/

			void DICOMActivado( GNC::GCS::IVista* pVista);

			void DICOMDesactivado( GNC::GCS::IVista* pVista);
//endregion

			//interfaz modelo dicom
			PanelPaciente* GetPaciente(const GNC::GCS::ControladorHistorial::ModeloSerie& modeloSerie, bool desplegarNodo = false);
			wxColour GetColorPaciente(const std::string& idPaciente);
			//
						
			void ForzarCargarTodos();
			std::list<std::string> GetOpenedSeriesUIDs();
			std::list<std::string> GetOpenedStudiesUIDs();
			GNC::GCS::IVista* GetVistaFromSeriesUID(const std::string& uid);
			GNC::GCS::IVista* GetVistaFromStudyUID(const std::string& uid);
		protected:
			virtual void OnCheckFromClick(wxCommandEvent &event);
			virtual void OnCheckToClick(wxCommandEvent &event);
			virtual void OnPlegarFilters(wxCommandEvent &event);
			virtual void OnPlegarClick(wxCommandEvent& event);
			virtual void OnDesplegar(wxMouseEvent& event);
			virtual void Plegar(bool plegar);
			virtual void OnDateFromChanged( wxDateEvent& event );
			virtual void OnDateToChanged( wxDateEvent& event );
			virtual void OnComboBox( wxCommandEvent& event );
			virtual void OnKeyDown(wxKeyEvent& event );
		public:
			virtual void RecargarBusqueda( bool force = false );
		protected:
			void PurgarHistorial(bool ignoreActual = false);
			void OnSize(wxSizeEvent &event);
			void OnMenuMouse(wxMouseEvent &event);
			virtual void OnMouseWheel(wxMouseEvent &event);
			virtual void OnMedicalHistoryClick(wxMouseEvent &event);
			void OnLimpiarHistorial(wxCommandEvent &event);
			void LimpiarHistorial();
			void OnImportar(wxCommandEvent& event);
			void OnAdquirir(wxCommandEvent& event);
			void Eliminar();
			void Detach(wxWindow* pHijo);
			virtual void PreProcesarEvento(GNC::GCS::Eventos::IEvento *, GNC::GCS::IControladorEventos::TipoListaPunterosEventos& );
			virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt);

			typedef std::map<std::string, GNC::GUI::PanelPaciente*> TMapaAbribles;

			TimerRecargarHistorial* m_pTimerRecargar;

			TMapaAbribles m_mapaUIDsAbribles;

			//seleccionar..
			GNC::GUI::ISeleccionableHistorial* m_pSeleccionado;
			
			std::string m_pacienteActual;
			std::string m_modalidadActual;
			wxDateTime m_fromActual;
			wxDateTime m_toActual;
		};
	}
}

