/*
 *  
 *  $Id: herramientainterpolate.cpp 4869 2012-04-19 11:47:15Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <wx/menu.h>

#include <api/globals.h>
#include <api/iwidgetsmanager.h>
#include "herramientainterpolate.h"
#include <main/controllers/controladoreventos.h>
#include <eventos/eventosginkgo.h>


#ifdef __DEPRECATED
#undef __DEPRECATED
#endif

#include <vtkObject.h>
#include <vtkSmartPointer.h>
#include <vtkPointData.h>
#include <vtkImageData.h>
#include <vtkLookupTable.h>
#include <vtkImageActor.h>
#include <vtkRenderer.h>
#include <vtkRenderWindow.h>
#include <vtkRenderWindowInteractor.h>
#include <vtk/vtkginkgoimageviewer.h>
#include <resources/ginkgoresourcemanager.h>

#define SET_INTERPOLATE  1741

namespace GNC {
	namespace GUI {
		class EventHandlerInterpolate: public wxEvtHandler {
		public:
			EventHandlerInterpolate(wxWindow* pParent, GNC::HerramientaInterpolate* pHerramienta):wxEvtHandler()
			{
				m_pParent = pParent;
				m_pHerramienta=pHerramienta;
				m_pParent->Connect(SET_INTERPOLATE, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerInterpolate::OnSetIntepolateClick),NULL,this);
				m_pParent->Connect(SET_INTERPOLATE, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(EventHandlerInterpolate::OnSetIntepolateUI),NULL,this);

			}
			~EventHandlerInterpolate()
			{
				m_pParent->Disconnect(wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerInterpolate::OnSetIntepolateClick),NULL,this);
				m_pParent->Disconnect(wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(EventHandlerInterpolate::OnSetIntepolateUI),NULL,this);
				m_pParent = NULL;
				m_pHerramienta = NULL;
			}

			void OnSetIntepolateClick( wxCommandEvent& event )
			{
				m_pHerramienta->SolicitarActivacion(GNC::GCS::TriggerButton().EnableLeft());
				event.Skip(false);
			}

			void OnSetIntepolateUI(wxUpdateUIEvent& event) {
				if(m_pHerramienta->IsSet()) {
					event.SetText(_("Unset pixels bluring"));
				} else {
					event.SetText(_("Set pixels bluring"));
				}
				event.Enable(m_pHerramienta->Habilitada());
			}

			GNC::HerramientaInterpolate* m_pHerramienta;
			wxWindow* m_pParent;
		};
		class MenuHerramientaInterpolate : public wxMenuItem {
		public:
			MenuHerramientaInterpolate(wxWindow* pParent, wxMenu* pMenuPadre, GNC::HerramientaInterpolate* pHerramienta):wxMenuItem(pMenuPadre,SET_INTERPOLATE,wxT("Mostrar las anotaciones de la ventana"),wxT("Mostrar las anotaciones de la ventana"),wxITEM_NORMAL) {
				pEventHandler = new EventHandlerInterpolate(pParent,pHerramienta);
				#ifdef __WXMSW__
				SetBitmaps(GinkgoResourcesManager::IconosHerramientas::GetIcoCornerAnnotations());
				#else
					SetBitmap(GinkgoResourcesManager::IconosHerramientas::GetIcoCornerAnnotations());
				#endif
			}

			~MenuHerramientaInterpolate() {
				if(pEventHandler != NULL) {
					delete pEventHandler;
					pEventHandler = NULL;
				}
			}

			EventHandlerInterpolate* pEventHandler;
		};
	}
}

//----------------------------------------------------------------------

GNC::HerramientaInterpolate::HerramientaInterpolate()
{
	m_Descripcion = _Std("Pixels bluring");
	m_IsMenu = true;
	m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoCornerAnnotations();
}

GNC::HerramientaInterpolate::~HerramientaInterpolate()
{
}

bool GNC::HerramientaInterpolate::AppendInMenu(wxWindow* pParent, wxMenu* pMenuParent)
{
	pMenuParent->Append(new GNC::GUI::MenuHerramientaInterpolate(pParent,pMenuParent,this));
	return true;
}

//region "Realizacion de la interfaz IHerramienta"

void GNC::HerramientaInterpolate::CrearPaneles( wxPanel* /*panel*/ )
{
	m_pAbstractPanelHerramientaOpciones =  NULL;
}

bool GNC::HerramientaInterpolate::IsSet()
{
	bool isSet = false;
	if(TContratableWidgets::m_pVistaActiva != NULL && TContratableWidgets::m_pListaActiva != NULL) {
		for (TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin(); it1 != TContratableWidgets::m_pListaActiva->end(); it1++) {
			TContratoWidgets* pCW = (*it1);
			isSet = pCW->GetViewerActivo()->GetInterpolationMode() == VTK_LINEAR_INTERPOLATION;
		}
	}
	return isSet;
}

void GNC::HerramientaInterpolate::SolicitarActivacion(const GNC::GCS::TriggerButton&)
{
	GTRACE("GNC::HerramientaInterpolate::Resetear()");
	for (TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin(); it1 != TContratableWidgets::m_pListaActiva->end(); it1++) {
		TContratoWidgets* pCW = (*it1);
		// Copio la lista
		if (pCW->Inicializado()) {
			TContratoWidgets::TViewerList list;
			pCW->GetAllViewers(list);
			bool enable = false;
			if (pCW->GetViewerActivo()->GetInterpolationMode() == VTK_LINEAR_INTERPOLATION) {
				enable = true;
			}
			for (TContratoWidgets::TViewerList::iterator it = list.begin(); it != list.end(); it++) {
				vtkGinkgoImageViewer* pW = (*it);
				if (enable) {
					pW->SetInterpolationMode(VTK_NEAREST_INTERPOLATION);
				}
				else {
					pW->SetInterpolationMode(VTK_LINEAR_INTERPOLATION);
				}
			}
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GCS::Eventos::EventoRender(TContratableWidgets::m_pVistaActiva));
		}
	}
}

void GNC::HerramientaInterpolate::ConectarContratoFalso(bool ) {
	if (TContratableWidgets::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

}

void GNC::HerramientaInterpolate::SetVistaActiva(GNC::GCS::IVista* pVista) {
	TContratableWidgets::EstablecerVistaActiva(pVista);
	GTRACE("GNC::HerramientaReset::EstablecerVistaActiva(pVista);::SetVistaActiva(" <<  pVista << ")");
}

// FIXME: Aviso!!!! para que funcione deben contratarse contratos pareados obligatorios y en el mismo orden
void GNC::HerramientaInterpolate::ConectarContratos(bool )
{
	if (TContratableWidgets::m_pListaActiva == NULL) {
		std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

}

//endregion



