/*
 *  
 *  $Id: visualizatorcontroller.h 3963 2011-07-11 14:03:51Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include <api/icontroladormodulo.h>
#include "../vistas/vista2d.h"

namespace GIL{
	class IModeloIntegracion;
}

namespace GNKVisualizator{
	namespace GUI{
		class ContenedorHerramientas;
	}
}
/* Controlador del módulo visor DICOM */
namespace GNKVisualizator {
	class ControladorAtencionPrimaria : public GNC::GCS::IControladorModulo {
	public:

		/* Constructor */
		ControladorAtencionPrimaria(GNC::GCS::IEntorno* pEntorno);

		/* Destructor */
		~ControladorAtencionPrimaria();

		virtual void RegistrarVistas();
		virtual bool SupportsImportationUID(const std::string &importationUID);

		/* Abre un estudio de manera no interactiva desde un directorio y devuelve su controlador específico */
		virtual GNC::GCS::IVista* AbrirVista(int modo, ListaDescriptoresSerie& series, const std::string& uidEstudioDiagnostico = "");

		virtual bool SeleccionarDiagnostico(const std::string& rutaFichero, std::string& uidDiagnosticoSeleccionado);

		// Metodos de inicializacion de la configuracion particular
		virtual bool SoportaImportacion() const;

		void GetPasosImportacion(IWizard* pWizard,std::list<IPasoWizard*> &listaPasos, wxWindow* pParent, std::string &dirTemporal,GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion);

		//region "Manipulacion de paneles extra (Herramientas, etc.)"
		virtual void InsertarPaneles();

		virtual void EliminarPaneles();

		virtual void MostrarPaneles(bool izquierdo = true, bool derecho = true);

		virtual void OcultarPaneles(bool izquierdo = true, bool derecho = true);
		//endregion

		virtual void ReprocessIntegration(const std::string& uidSeries, GnkPtr<GIL::IModeloIntegracion> pIntegrationModel);

	protected:
		GNKVisualizator::GUI::ContenedorHerramientas* m_pPanelContenedorCustom;
	};
}
