#ifdef HAVE_GNOME

#include "defines.h"

#include <gtk/gtk.h>
#include <applet-widget.h>

#include "actions.h"
#include "applet.h"
#include "gui.h"

extern GtkWidget *main_window;
extern GtkWidget *main_combo;
extern guint is_applet;
extern int state;

extern GdkPixmap *in_out_on;
extern GdkPixmap *in_out_off;
extern GdkBitmap *in_out_mask;

/* the applet */
GtkWidget *applet;

GtkWidget *btn;

GtkWidget *btn_on_off,
  *label_on_off;

GtkWidget *applet_frame,
  *darea;

GtkWidget *applet_pixmap;

GdkPixmap *applet_on, 
  *applet_off,
  *applet_waiting;

GtkWidget *applet_in_pix;
GtkWidget *applet_out_pix;

GdkBitmap *applet_mask;
GtkStyle *applet_style;

GtkTooltips *time_tip;
GtkTooltips *inout_tip;

/*
  Creates the panel and its widgets, attaches them and controls
*/
void create_panel_applet ()
{
  /* creates the main applet */
  applet = applet_widget_new(PACKAGE);
  if (!applet)
    {
      gk_diag (_("Couldn't connect applet to panel..."));
      is_applet = FALSE;
      return;
    }
  gtk_signal_connect (GTK_OBJECT(applet), "change_orient",
		      GTK_SIGNAL_FUNC(gk_change_orient),
		      NULL);
#ifdef HAVE_PANEL_PIXEL_SIZE
  gtk_signal_connect (GTK_OBJECT(applet), "change_pixel_size",
		      GTK_SIGNAL_FUNC(gk_change_pixel_size),
		      NULL);
#endif

  
  /* the frame */
  applet_frame = gtk_fixed_new();
  gtk_widget_show (applet_frame);

  darea= gtk_drawing_area_new ();
  gtk_drawing_area_size (GTK_DRAWING_AREA(darea), 15, 15);
  gtk_fixed_put(GTK_FIXED(applet_frame), darea, 0, 0);
  gtk_widget_show (darea);

  /* on/off button */
  btn_on_off = gtk_button_new ();
  gtk_widget_set_usize (btn_on_off, 23, 23);
  label_on_off = gtk_label_new ("On");
  gtk_container_add (GTK_CONTAINER(btn_on_off), label_on_off);
  gtk_signal_connect (GTK_OBJECT(btn_on_off), "clicked",
		      GTK_SIGNAL_FUNC(applet_on_off),
		      NULL);
  gtk_fixed_put (GTK_FIXED(applet_frame), btn_on_off, 0, 0);
  gtk_widget_show (label_on_off);
  gtk_widget_show (btn_on_off);

  /* creates the button, if you click it it'll show the main window */
  btn = gtk_button_new ();
  gtk_widget_set_usize (btn, 23, 23);
  gtk_signal_connect (GTK_OBJECT(btn), "clicked",
		      GTK_SIGNAL_FUNC (applet_callback),
		      NULL);
  gtk_fixed_put (GTK_FIXED(applet_frame), btn, 25, 0);
  gtk_widget_show (btn);
  
  /* in/out pixmaps */
  applet_in_pix = gtk_pixmap_new (in_out_off, in_out_mask);
  gtk_fixed_put (GTK_FIXED(applet_frame), applet_in_pix, 48, 3);
  gtk_widget_show (applet_in_pix);

  applet_out_pix = gtk_pixmap_new (in_out_off, in_out_mask);
  gtk_fixed_put (GTK_FIXED(applet_frame), applet_out_pix, 48, 15);
  gtk_widget_show (applet_out_pix);

  /* tooltips */
  time_tip = gtk_tooltips_new ();
  gtk_tooltips_set_tip (GTK_TOOLTIPS(time_tip), btn_on_off,
			_("Time"), NULL);

  inout_tip = gtk_tooltips_new ();
  gtk_tooltips_set_tip (GTK_TOOLTIPS(inout_tip), btn,
			_("In / Out"), NULL);

  /* setting the pixmap into the button */
  applet_style = gtk_widget_get_style (applet);
  /* on */
  applet_on = create_gkdial_image (main_window, "applet_on.xpm", 
				   applet_mask);

  /* off */
  applet_off = create_gkdial_image (main_window, "applet_off.xpm", 
				    applet_mask);

  /* while waiting for connection to complete */
  applet_waiting = create_gkdial_image (main_window, "applet_waiting.xpm", 
					applet_mask);

  applet_pixmap = gtk_pixmap_new (applet_off, applet_mask);
  gtk_widget_show (applet_pixmap);

  gtk_container_add (GTK_CONTAINER(btn), applet_pixmap);

  /* putting the tables in the applet */
  applet_widget_add (APPLET_WIDGET(applet), applet_frame);
  gtk_widget_show (applet);

}

#ifdef HAVE_PANEL_PIXEL_SIZE
/* 
   When panel size gets changed we will change the orientation of
   gkdial
*/
void gk_change_pixel_size (GtkWidget *w, int size, gpointer data)
{
  if (size >= PIXEL_SIZE_STANDARD)
    gk_applet_set_vertical();
  else
    gk_applet_set_horizontal();
}
#endif

/*
  when orientation is changed in the panel, this function
  gets called
*/
void gk_change_orient (GtkWidget *w, PanelOrientType orient, gpointer data)
{
  /* 
     I don't really know how this will work on different themes and
     fonts but I'll try to find a good way of doing this...
  */

  switch (orient)
    {
    case ORIENT_DOWN:
    case ORIENT_UP:
      gk_applet_set_horizontal();
      break;
    case ORIENT_RIGHT:
    case ORIENT_LEFT:
      gk_applet_set_vertical();
      break;
    }
}

void gk_applet_set_horizontal ()
{
  gtk_fixed_move (GTK_FIXED(applet_frame), btn_on_off, 0, 0);
  gtk_fixed_move (GTK_FIXED(applet_frame), btn, 25, 0);
  gtk_fixed_move (GTK_FIXED(applet_frame), applet_in_pix, 48, 3);
  gtk_fixed_move (GTK_FIXED(applet_frame), applet_out_pix, 48, 15);
}

void gk_applet_set_vertical ()
{
  gtk_fixed_move (GTK_FIXED(applet_frame), btn_on_off, 0, 0);
  gtk_fixed_move (GTK_FIXED(applet_frame), btn, 0, 25);
  gtk_fixed_move (GTK_FIXED(applet_frame), applet_in_pix, 3, 48);
  gtk_fixed_move (GTK_FIXED(applet_frame), applet_out_pix, 15, 48);
}

/* 
   This callback connects and disconnects based on connection
   status
*/
void applet_on_off (GtkWidget *w, gpointer data)
{
  switch (state)
    {
    case CONNECTED:
    case CONNECTING:
    case DISCONNECTING:
      gk_disconnect (NULL, NULL);
      break;
    case DISCONNECTED:
      gk_connect (NULL, NULL);
      break;
    }
}

/*
  Used to set the state (color) of the applet
  also sets the button On/Off
*/
void gk_applet_set_state (guint which)
{
  switch (which)
    {
    case PIX_ON:
      gtk_pixmap_set (GTK_PIXMAP(applet_pixmap), applet_on, applet_mask);
      gtk_label_set_text (GTK_LABEL(label_on_off), "Off");
      break;
    case PIX_WAITING:
      gtk_pixmap_set (GTK_PIXMAP(applet_pixmap), applet_waiting, applet_mask);
      gtk_label_set_text (GTK_LABEL(label_on_off), "Off");
      break;
    default:
      gtk_pixmap_set (GTK_PIXMAP(applet_pixmap), applet_off, applet_mask);
      gtk_label_set_text (GTK_LABEL(label_on_off), "On");
    }
}

/* sets the blinking colors to show network traffic */
void app_set_in_out (int in, int out)
{
  if (in)
    gtk_pixmap_set (GTK_PIXMAP(applet_in_pix), in_out_on, in_out_mask);
  else
    gtk_pixmap_set (GTK_PIXMAP(applet_in_pix), in_out_off, in_out_mask);

  if (out)
    gtk_pixmap_set (GTK_PIXMAP(applet_out_pix), in_out_on, in_out_mask);
  else
    gtk_pixmap_set (GTK_PIXMAP(applet_out_pix), in_out_off, in_out_mask);
}

/* 
   Shows or hides main window
*/
void applet_callback (GtkWidget *w, gpointer data)
{
  if (!GTK_WIDGET_VISIBLE(main_window))
    gtk_widget_show(main_window);
  else
    gtk_widget_hide(main_window);
}

#endif
