#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#include "defines.h"
#include "conf.h"
#include "actions.h"
#include "gui.h"

extern GtkWidget *main_combo;

extern char last_choice[FILENAME_MAX];

extern gchar modem_tty[FILENAME_MAX];
extern gchar lock_file[FILENAME_MAX];
extern gchar connect_cmd[FILENAME_MAX];
extern gchar disconnect_cmd[FILENAME_MAX];

guint conf_timeout;

/* checks configuration */
void check_config ()
{
  FILE *f;
  gchar conffile[FILENAME_MAX];
  guint is_first_run = FALSE;

  strncpy (conffile, getenv("HOME"), FILENAME_MAX);
  strcat (conffile, "/.gkdial");
  
  /* checks for file existance */
  if (access (conffile, R_OK) == -1)
    {
      /* "touches" the file */
      f = fopen (conffile, "w");
      fclose(f);
      is_first_run = TRUE;
      first_run();
    }
  else if (!getvalue ("modem_tty=", modem_tty) ||
	   !getvalue ("connect_cmd=", connect_cmd) ||
	   !getvalue ("disconnect_cmd=", disconnect_cmd))
    {
      is_first_run = TRUE;
      first_run();
    }

  if (is_first_run)
    gtk_timeout_add (1000, set_conf_values, NULL);
  else
    set_conf_values(NULL);
}

void first_run ()
{
  /* gets the modem device from the user */
  configure_prefs (NULL, "modem");
  
  gk_diag (_("This seems to be the first time you run GkDial.\n"
	     "Welcome! =)\n\n"
	     "You have no ~/.gkdial configuration file, this\n"
	     "file lists some important information: the device\n"
	     "file used by your modem, the lock file that\n"
	     "is monitored to get connection status, etc.\n\n"
	     "I'll create a default file, you may reconfigure\n"
	     "this file by hand or using the \"Preferences\"\n"
	     "menu in GkDial's main window.\n\n"
	     "Thanks for using this program =) !"));
}

gint set_conf_values (gpointer data)
{
  gchar modem_tmp[FILENAME_MAX];
  gchar *tmp = NULL;

  /* 
     we'll wait 'till we have a modem set up so we can set the
     other defaults 
  */
  if (!strlen(modem_tty))
    return 1;

  if (!getvalue ("modem_tty=", modem_tty))
    strncpy (modem_tty, MODEM_DEFAULT, FILENAME_MAX);
  if (!getvalue ("lock_file=", lock_file))
    {
      strncpy (modem_tmp, modem_tty, FILENAME_MAX);
      tmp = strrchr (modem_tmp, '/');
      if (tmp == NULL)
	{
	  fprintf (stderr, 
		   _("GkDial: WARNING: Your modem device (%s) doesn't contain '/dev'"
		     "in its name, you should specify it as an absolute name\n"),
		   modem_tty);
	  strncpy (lock_file, LOCK_DEFAULT, FILENAME_MAX);
	}
      else
	{
	  strcpy (lock_file, "/var/lock/LCK..");
	  strcat (lock_file, tmp+1);
	}
    }

  if (!getvalue ("connect_cmd=", connect_cmd))
    strncpy (connect_cmd, UPCMD, FILENAME_MAX);
  if (!getvalue ("disconnect_cmd=", disconnect_cmd))
    strncpy (disconnect_cmd, DOWNCMD, FILENAME_MAX);

  conf_write();

  if (!combo_insert_options (main_combo))
    {
      gchar gk_msg[1024];

      sprintf (gk_msg, 
	       _("You doesn't seem to have a ppp connection\n"
		 "set up (no file was found in %s).\n"
		 "To set up a new connection you need to be\n"
		 "root, if you are not, follow these\n"
		 "instructions:\n\n"
		 " Open an xterm and run these commands:\n"
		 " $ xhost + 127.0.0.1 <enter>\n"
		 " $ su <enter>\n"
		 " Password: (type in your root password)\n"
		 " # gkdial <enter>\n\n"
		 "The gkdial's window is going to be opened,\n"
		 "click \"Add\" and fill in the fields with\n"
		 "the information gotten from your ISP"),
	       PEERS_DIR);
      gk_diag (gk_msg);
    }

  return 0;
}

void configure_prefs (GtkWidget *w, gpointer data)
{
  gchar *config = (gchar*)data;
  gchar label_content[1024];
  gchar default_value[FILENAME_MAX];

  bzero(default_value, FILENAME_MAX);

  if (!strcmp(config, "modem"))
    {
      getvalue ("modem_tty=", default_value);
      strncpy (label_content, 
	       _("While adding new connections to use with GkDial\n"
		 "or pon/poff, GkDial sets the modem device to be\n"
		 "used. For example: /dev/ttyS2 (this is also know\n"
		 "as COM3).\n\n"
		 "Wich one should be used? (Try setting to /dev/modem\n"
		 "if you don't know)."),
	       1024);
    }
  else if (!strcmp(config, "lock"))
    {
      getvalue ("lock_file=", default_value);
      strncpy (label_content, 
	       _("GkDial uses a file to monitor wether the connection\n"
		 "is up or not. The default is to check for the file\n"
		 "/var/lock/LCK..????? (where the ??? is your modem\n"
		 "device without the /dev/)."),
	       1024);
    }
  else if (!strcmp(config, "connect_cmd"))
    {
      getvalue ("connect_cmd=", default_value);
      strncpy (label_content,
	       _("GkDial uses other programs to create and close connections.\n"
		 "Type in the command used to create the connection. Please,\n"
		 "use absolute path names. GkDial calls the command defined\n"
		 "here with the connection name wich you selected.\n\n"
		 "For example: if you type: /usr/sbin/pppd call here, and you\n"
		 "select 'provider' in the main window. GkDial will call:\n"
		 "/usr/bin/pppd call provider"),
	       1024);
    }
  else if (!strcmp(config, "disconnect_cmd"))
    {
      getvalue ("disconnect_cmd=", default_value);
      strncpy (label_content,
	       _("GkDial uses other programs to create and close connections.\n"
		 "Type in the command used to close the connection. Please,\n"
		 "use absolute path names. For example: /usr/bin/killall pppd"),
	       1024);
    }

  create_config_window (label_content, default_value, config);
}

/* gets a value from a line with a 'key=value' pattern */
int getvalue (gchar *key, gchar *str)
{
  FILE *cf;
  gchar line[256];
  gchar *tmp;
  gchar *c;

  gchar conffile[FILENAME_MAX];

  strncpy (conffile, getenv("HOME"), FILENAME_MAX);
  strcat (conffile, "/.gkdial");

  if (!access (conffile, R_OK))
    {
      if ((cf = fopen (conffile, "r")) == NULL)
	{
	  fprintf(stderr, _("Error! Could not open %s\n"), conffile);
	  return -1;
	}
      while (fgets(line, 255, cf))
      {
	if (!strncmp(line, key, strlen(key)))
	  {
	    tmp = strchr(line, '=');
	    c = strchr (tmp, '\n');
	    *c = '\0';
	    tmp = tmp++;
	    if (str != NULL)
	      strncpy (str, tmp, FILENAME_MAX);
	    return 1;
	  }
      }
      fclose(cf);
    }
  else
    {
      gk_diag (_("Error! Could not open ~/.gkdial!"));
      fprintf(stderr, _("Error! Could not open %s!"), conffile);
      return -1;
    }

  return 0;
}

/* writes configuration to the config file */
void conf_write ()
{
  FILE *cf;
  gchar conffile[FILENAME_MAX];

  strncpy (conffile, getenv("HOME"), FILENAME_MAX);
  strcat (conffile, "/.gkdial");

  if ((cf = fopen (conffile, "w")) == NULL)
    {
      gk_diag (_("Error opening ~/.gkdial for writing"));
      return;
    }

  if (strlen (modem_tty))
    fprintf (cf, "modem_tty=%s\n", modem_tty);
  if (strlen (lock_file))
    fprintf (cf, "lock_file=%s\n", lock_file);
  if (strlen(connect_cmd))
    fprintf (cf, "connect_cmd=%s\n", connect_cmd);
  if (strlen (disconnect_cmd))
      fprintf (cf, "disconnect_cmd=%s\n", disconnect_cmd);
  if (strlen (last_choice))
    fprintf (cf, "last_choice=%s\n", last_choice);

  fclose (cf);
}

/* configs the command used to create the connection */
void conf_set_connect_cmd (GtkWidget *w, gpointer data)
{
  gchar *tmp;

  tmp = gtk_entry_get_text (GTK_ENTRY(data));
  strncpy (connect_cmd, tmp, FILENAME_MAX);
  conf_write();
}

/* configs the command used to create the connection */
void conf_set_disconnect_cmd (GtkWidget *w, gpointer data)
{
  gchar *tmp;

  tmp = gtk_entry_get_text (GTK_ENTRY(data));
  strncpy (disconnect_cmd, tmp, FILENAME_MAX);
  conf_write();
}

/* configs the modem */
void conf_set_modem (GtkWidget *w, gpointer data)
{
  gchar *tmp;

  tmp = gtk_entry_get_text (GTK_ENTRY(data));
  strncpy (modem_tty, tmp, FILENAME_MAX);
  conf_write ();
}

/* configs the lock */
void conf_set_lock (GtkWidget *w, gpointer data)
{
  gchar *tmp;

  tmp = gtk_entry_get_text (GTK_ENTRY(data));
  strncpy (lock_file, tmp, FILENAME_MAX);
  conf_write ();
}
