// $Id: Widget.cc,v 1.20 2001/10/11 14:07:23 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "Widget.hh"
#include "writers/WriterBase.hh"
#include <cstring>

static std::string UniqueName(const std::string &prefix,const void *addr)
{  std::string ret(prefix);
   unsigned long val=(unsigned long)addr;
   if (sizeof(val)<sizeof(addr)) 
      std::cerr<<"Warning: Widget::UniqueName: truncating address\n";
   unsigned int bit;
   const int size=5;
   for (bit=0;bit<8*(sizeof val);bit+=size)
      ret+="QCDGHKLMJNPVWYZXqcdghklmjnpvwyzx"[(val>>bit)&((1<<size)-1)];
      // selecting really unreadable names
   return ret;
}

const std::string Widget::Name() const throw()
{  if (name.size()) return name;
   name=getString("name");
   if (!name.size()) name=UniqueName("Widget",tag);
   return name;
}

const ChildParamList Widget::get_Child_params() const throw()
{  const Tag *t=tag->find("child");
   if (t) return ChildParamList(*t);
#if 0   
   // XXX: we should kill this pre 0.5 compatibility ???
   return ChildParamList(*tag,false);
#else
   static const Tag empty_list("child");
   return ChildParamList(empty_list);
#endif
}

Subwidget Widget::subwidgettype(const Widget &w) const throw()
{  return LookupWriter(*this).IsSubwidget(*this,w);
}

