// $Id: WidgetFile.cc,v 1.13 2001/10/11 14:07:23 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 2001 Adolf Petig GmbH & Co. KG
 *  written by Christof Petig and Malte Thoma
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include <WidgetFile.hh>
#include <Configuration.hh>
#include <string>

WidgetFile::WidgetFile(const Widget &w,File_type tp) 
        : CxxFile(Configuration.FileName(w.Name(),tp,File_NOREPLACE).c_str()),
          top(w.getTagPtr()), _type(tp), has_requirements(false)
{  
}

void WidgetFile::open(const Widget &w,File_type tp) 
{  CxxFile::open(Configuration.FileName(w.Name(),tp,File_NOREPLACE).c_str());
   top=w.getTagPtr();
   _type=tp;
}
                                           
const std::string WidgetFile::FileName(File_type tp,int flags)
{  return Configuration.FileName(Widget(*top).Name(),tp,flags);
}

void WidgetFile::close()
{ CxxFile::close();
  unsigned int end_laenge = Configuration.template_postfix.size() ; 
  if ( _type==File_FOO_GLADE_HH || 
       _type==File_FOO_GLADE_CC ||
       _type==File_SUPPORT_CC ||
       _type==File_SUPPORT_CC )
   {  std::string filename_new = SystemFile::FileName();
      std::string filename_old = FileName(0);
      if (filename_new!=filename_old)
      {  // ignore timestamp, version and command line differences
         std::string syscall_d ="diff ""-I '// generated .+' "
      			"-I '// using glademm V.+' "
      			"-I '// .*glade-- .+' "
      			"-I '// for gtk .+ and gtkmm .+' "
   			+filename_new +" "+filename_old +" > /dev/null ";
         bool changed = system(syscall_d.c_str());
         if (changed) 
         {  std::string syscall_m = "mv "+filename_new +" "+filename_old;
            system(syscall_m.c_str());
         }
         else
         {  std::string syscall_m = "rm "+filename_new;
            system(syscall_m.c_str());
         }
      }
   }
}
