// $Id: button.cc,v 1.28 2002/02/15 10:46:53 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "button.hh"

void Gtk_Button::ApplyPreferences(Tag &t) const
{  Parent::ApplyPreferences(t);
   if (!Configuration.gnome_support && t.hasTag("stock_button"))
   {  // hmmm, turn on gnome_support or turn stock_button to label?
      std::cerr << "Stock Buttons need gnome_support, please turn it on\n";
      Configuration.gnome_support=true;
   }
}

void Gtk_Button::GCInclude(const Widget &w, CxxFile &f) const
{  if (w.hasTag("stock_button"))
      f.Include("libgnomeui/gnome-stock.h");
   Parent::GCInclude(w,f);
}

const std::string Gtk_Button::TypeName(const Widget &w) const
{  return GtkPrefix()+"Button";
}

const std::string Gtk_Button::IncludeName(const Widget &w) const
{  return "gtk--/button.h";
}

Gtk_Button::Gtk_Button(bool base_class_init)
{  if (!base_class_init) Writer["GtkButton"]=this;
}

void Gtk_Button::ConstructionArgs(const Widget &w, CxxFile &f) const
{  assert(!w.hasTag("stock_button"));
   if (w.hasTag("label"))
   {  f.FunctionArg();
      std::string label=w.getString("label");
      if (label.find('_')!=std::string::npos)
         f << "\"\"";
      else
         f << Configuration.Translatable(label);
   }
}

void Gtk_Button::CreatePointer(const Widget &w,CxxFile &f) const
{  if (w.hasTag("stock_button"))
   {  if (w.getString("cxx_visibility","private")=="private") // && CanBeManaged(w))
	 f.Declaration() << TypeName(w) << " *";
      else 
	 f.Statement();
      f << Configuration.InstanceName(w.Name());
      f.Assignment().FunctionName(GtkPrefix()) << "wrap";
      // or f << GtkCast(w) <<'(';
      f.FunctionArg() << '(' << GtkName(w) << "*)"
      		 "gnome_stock_button(" << w.getString("stock_button") << ')';
      f.EndLine();
      w.markManaged();
   }
   else Parent::CreatePointer(w,f);
}

void Gtk_Button::DestroyPointer(const Widget &w,CxxFile &f) const
{  Parent::DestroyPointer(w,f);
}

bool Gtk_Button::NeedExplicitCtor(const Widget &w) const
{  return w.hasTag("label"); }

static Gtk_Button Gtk_Button(false);

bool Gtk_Button::CantMemberConstruct(const Widget &w) const
{  return w.hasTag("stock_button");
}

void Gtk_Button::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   std::string relief=w.getString("relief","GTK_RELIEF_NORMAL");
   if (relief!="GTK_RELIEF_NORMAL")
      f.Statement() << instance << "set_relief(" << relief << ')';
      
   std::string label=w.getString("label");
   if (label.find('_')!=std::string::npos)
      f.Statement() << "dynamic_cast<Gtk::Label*>(" << instance << "get_child())->"
      		"parse_uline(" << Configuration.Translatable(label) << ")";
}
