// $Id: container.cc,v 1.30 2002/03/01 21:50:25 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "container.hh"

void Gtk_Container::AddMenuChild(const Widget &w,CxxFile &f, 
				 const std::string &instance) const
{
  std::string gtkClass=w.Class();
  gtkClass.replace(gtkClass.find("Gtk"), sizeof("Gtk")-1, "Gtk::"); // ***
  
  if(gtkClass.find("MenuItem")!=std::string::npos) {
    std::string elemType=gtkClass, accel, callback, submenu;
    std::string childInstance=Configuration.InstanceName(w.Name()) + "->";

    if(!w.hasTag("label")) {
      elemType="Gtk::Menu_Helpers::SeparatorElem";
    } else {
      elemType.replace(elemType.find("Gtk::"), sizeof("Gtk::")-1, 
		       "Gtk::Menu_Helpers::");
      elemType.replace(elemType.find("Item"),  sizeof("Item")-1,
		       "Elem");

      /* Convert accelerator spec to parseable string. May actually have
	 passed something like mods|key directly instead, but this allows
	 accelerators to be localized. */
      if (Configuration.has_accelerators && w.hasTag("accelerator")) {  
	for (Widget::const_iterator i=w.get_Accels();i!=w.end();++i) {
	  std::string mods(i->getString("modifiers"));
	  std::string key(i->getString("key"));
	  std::string::size_type rm;
	  
	  // Remove some unwanted text from strings. *** Is there a standard
	  // function/method that will erase all occurences of a substring?

	  for(rm=key.find("GDK_"); rm!=std::string::npos; rm=key.find("GDK_"))
	    key.erase(rm, sizeof("GDK_")-1);
	  for(rm=key.find(" "); rm!=std::string::npos; rm=key.find(" "))
	    key.erase(rm, sizeof(" ")-1);
	  
	  for(rm=mods.find("GDK_"); rm!=std::string::npos; rm=mods.find("GDK_"))
	    mods.erase(rm, sizeof("GDK_")-1);
	  for(rm=mods.find("_MASK"); rm!=std::string::npos; rm=mods.find("_MASK"))
	    mods.erase(rm, sizeof("_MASK")-1);
	  for(rm=mods.find(" "); rm!=std::string::npos; rm=mods.find(" "))
	    mods.erase(rm, sizeof(" ")-1);
	  for(rm=mods.find("0"); rm!=std::string::npos; rm=mods.find("0"))
	    mods.erase(rm, sizeof("0")-1);
	  
	  for(std::string::size_type modEnd=mods.find("|"); !mods.empty();
	      modEnd=mods.find("|")) {
	    std::string mod(mods, 0, modEnd);

	    mods=mods.substr(mod.size()); // Remove mod
	    
	    for(std::string::iterator p=mod.begin()+1; p!=mod.end(); p++)
	      *p=tolower(*p);

	    accel+="<" + mod + ">";
	  }
	  if(key.size()==1)
	    accel+=toupper(key[0]);
	  else
	    accel+=key;
	}
      }
      if(w.hasChildren())
	submenu=Reference(*w.begin());
    }
  
    f.Declaration();		// *** Necessary to get state right.

    f.FunctionName() << instance << "items().push_back";
    f.FunctionArg();
    f.FunctionName() << elemType;
    
    // *** Really want to call child's ConstructionArgs, and let this add label
    
    if (elemType=="Gtk::Menu_Helpers::RadioMenuElem")
      f.FunctionArg() << "_RadioMIGroup_" << w.getString("group","");
    // CP: I doubt omitting arguments will do good to the generated code
    if(w.hasTag("label"))
      f.FunctionArg() << Configuration.Translatable(w.getString("label"));
    if(!accel.empty())
      f.FunctionArg() << Configuration.Translatable(accel);
    if(!submenu.empty())
      f.FunctionArg() << submenu;
    else if(!callback.empty())
      f.FunctionArg() << callback;
    
    f.Statement() << Configuration.InstanceName(w.Name());
    f.Assignment() << "(" << gtkClass << " *)" << instance << "items().back()";

    // CP: this duplication of Gtk_Widget::Configure is not good !
    if (Configuration.widget_names)
    {  f.Statement() << childInstance << "set_name(" 
		     << Configuration.CString_WithQuotes(w.Name()) << ')';
    }
    if (!w.getBool("sensitive",true))
    {  f.Statement() << childInstance << "set_sensitive(false)";
    }

    if(gtkClass.find("CheckMenu")!=std::string::npos) {
      bool active=w.getBool("active");
      bool showToggle=w.getBool("always_show_toggle");

      if (active) 
	f.Statement() << childInstance << "set_active(" 
		      << PRINT_BOOL(active) << ')';
      if (showToggle) 
	f.Statement() << childInstance << "set_show_toggle(" 
		      << PRINT_BOOL(showToggle) << ')';
      
    } 
  } else {
    f.Statement() << instance << "append(" << Reference(w) << ')';
  }
}

void Gtk_Container::AddChildren(const Widget &w,CxxFile &f,const std::string &instance) const
{  for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  if ((*i).Class()!="Placeholder")
      // this may be the wrong writer and the wrong parent widget
      {  switch(IsSubwidget(w,*i))
         {  case no_Subwidgets: case not_Subwidget:
                 if ((*i).ChildName().size())
                    std::cerr << "Notice: adding of " << (*i).Name() << " to "
                    	<< w.Name() << " ignored, AddChildren needs fixing\n";
                 else
	   	    AddChild(*i,f,instance);
	   	 break;
	    default: // ok.
	         break;
	 }
      }
   }
}

void Gtk_Container::AddChild(const Widget &w,CxxFile &f,const std::string &instance) const
{ f.Statement() << instance << "add(" << Reference(w) << ')';
}


void Gtk_Container::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   int border_width=w.getInt("border_width",0);
   if (border_width)
      f.Statement() << instance << "set_border_width(" << border_width << ')';
}

void Gtk_Container::GHInclude(const Widget &w,CxxFile &f) const
{  Parent::GHInclude(w,f);
   if (!w.getBool(CXX_SEPERATE_CLASS,false)) return;
   bool children_have_tooltips=false;
   for (Widget::const_contained_iterator i=w.begin_contained(Internal_Both);
   		i!=w.end_contained();++i)
   {  Widget w(*i);
      if (w.isSeperateClass()) continue;
      if (w.hasTag("tooltip")) 
      {  children_have_tooltips=true;
         break;
      }
   }
   if (children_have_tooltips || w.hasTag("tooltip"))
   {  f.Include("gtk--/tooltips.h");
   }
}

void Gtk_Container::AdditionalMemberVars(const Widget &w, CxxFile &f,bool container) const
{  bool children_have_tooltips=false;
   if (!w.getBool(CXX_SEPERATE_CLASS,false)) return;
   for (Widget::const_contained_iterator i=w.begin_contained(Internal_Both);
   	i!=w.end_contained();++i)
   {  Widget w(*i);
      if (!container && w.getBool(CXX_SEPERATE_CLASS,false)) continue;
      if (w.hasTag("tooltip")) 
      {  children_have_tooltips=true;
         break;
      }
   }
   if (children_have_tooltips || w.hasTag("tooltip"))
   {  const std::string visibility(w.getString("cxx_visibility","private"));
      if (visibility=="private") f.Private();
      else if (visibility=="protected") f.Protected();
      else if (visibility=="public") f.Public();
      f.Declaration() << (GtkPrefix()+"Tooltips _tooltips");
   }
   Parent::AdditionalMemberVars(w,f,container);
}
