// $Id: frame.cc,v 1.20 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "bin.hh"

class Gtk_Frame : public Gtk_Bin
{public:
	typedef Gtk_Bin Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_Frame();
	virtual bool NeedExplicitCtor(const Widget &w) const;
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
};

static Gtk_Frame Gtk_Frame;

const std::string Gtk_Frame::TypeName(const Widget &w) const
{  return GtkPrefix()+"Frame";
}

const std::string Gtk_Frame::IncludeName(const Widget &w) const
{  return "gtk--/frame.h";
}

Gtk_Frame::Gtk_Frame()
{  Writer["GtkFrame"]=this;
}

void Gtk_Frame::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg();
   const std::string label(w.getString("label"));
   if (label.size()) f << Configuration.Translatable(label);
}

bool Gtk_Frame::NeedExplicitCtor(const Widget &w) const
{  return w.hasTag("label") && w.getString("label").size(); }

void Gtk_Frame::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   float label_xalign(w.getFloat("label_xalign",0));
   float label_yalign(w.getFloat("label_yalign",0));
   std::string shadow_type(w.getString("shadow_type","GTK_SHADOW_ETCHED_IN"));
   f.Statement() << instance << "set_label_align(" << label_xalign 
   	<< ", " << label_yalign << ')';
   f.Statement() << instance << "set_shadow_type(" << shadow_type << ')';
}
