// $Id: gnome_dialog.cc,v 1.16 2001/11/05 15:28:20 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
// to do: special dialog boxes : Dialogs::ok(const Gtk::string &msg);
// error, warning question, question_modal, ok_cancel, ok_cancel_modal
// request(bool hidden,const Gtk::string &prompt,const Gtk::string &default_text,const guint16 max_length,StringCallback cb=0);

#include <cstdio>
#include "gnome_dialog.hh"

static Gnome_Dialog Gnome_Dialog(false);

const std::string Gnome_Dialog::TypeName(const Widget &w) const
{  return GnomePrefix()+"Dialog";
}

const std::string Gnome_Dialog::IncludeName(const Widget &w) const
{  return "gnome--/dialog.h";
}

Gnome_Dialog::Gnome_Dialog(bool base_class_init)
{  if (!base_class_init)
      Writer["GnomeDialog"]=this;
}

void Gnome_Dialog::AddButtons(const Widget &w,CxxFile &f,const std::string &instance) const
{  for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  assert((*i).Class()=="GtkButton");
      assert((*i).begin()==(*i).end()); // no children
      const std::string stock_button((*i).getString("stock_button"));
      const std::string label((*i).getString("label"));
      const std::string stock_pixmap((*i).getString("stock_pixmap"));
#warning support for custom pixmap missing
      
      if (stock_button.size())
         f.Statement() << instance << "append_button(" << stock_button << ')';
      else if (!stock_pixmap.size())
         f.Statement() << instance << "append_button(" 
         	<< Configuration.Translatable(label) << ')';
      else
         f.Statement() << instance << "append_button(" 
         	<< Configuration.Translatable(label) << ", "
         	<< stock_pixmap << ')';
   }
}

// they are added elsewhere (vbox->AddChildren, AddChildren_B)
void Gnome_Dialog::AddChildren(const Widget &w,CxxFile &f,const std::string &instance) const
{  return;
}

void Gnome_Dialog::AddChildren_B(const Widget &w,CxxFile &f,const std::string &instance) const
{  if (w.begin()==w.end()) return;
   if (TypeName(w)=="Gnome::PropertyBox") return;
   const Widget w2(*(w.begin()));
   if (w2.ChildName().find(":vbox")==std::string::npos)
   {  std::cerr << w.Name() << ": Gnome_Dialog could not add its buttons ... good luck\n";
      return;
   }

   for (Widget::const_iterator i=w2.begin();i!=w2.end();++i)
   {  if ((*i).Class()!="Placeholder")
      {  switch(IsSubwidget(w,*i))
         {  case no_Subwidgets: case not_Subwidget:
	   	 break;
	    default: // ok.
 		 assert((*i).ChildName().find(":action_area")!=std::string::npos);
	         AddButtons(*i,f,instance);
	         break;
	 }
      }
   }
}

void Gnome_Dialog::ClassConstructor(const Widget &w,CxxFile &f) const
// CreatePointer_Toplevel is called too early, though it would be the right
// place to go
{  Parent::ClassConstructor(w,f);
   AddChildren_B(w,f,WriterBase::instance(w));
}

void Gnome_Dialog::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);

   if (w.begin()==w.end()) return; // e.g. GnomeAbout
   const Widget w2(*(w.begin()));
   if (w2.ChildName()!="GnomeDialog:vbox") return; // e.g. GnomePropertyBox
   for (Widget::const_iterator i=w2.begin();i!=w2.end();++i)
   {  if ((*i).ChildName()=="GnomeDialog:action_area")
      {  // PROBLEM: action_area is only != NULL if there are any 
      	 // children connected
	 f.Declaration() << GtkPrefix() << "HButtonBox *" 
	 	<< Configuration.InstanceName((*i).Name());
   	 f.Assignment() << "Gtk::wrap((GtkHButtonBox*)GNOME_DIALOG("
   		<< instance << "gtkobj())->action_area)";
         LookupWriter("GtkHButtonBox")
         	.Configure(*i,f,Configuration.InstanceName((*i).Name())+"->");
      }
   }
//   bool modal(w.getBool("modal")); // and what to do then?
   bool hide_on_close(w.getBool("hide_on_close"));
   if (hide_on_close)
      f.Statement() << instance << "close_hides(" << PRINT_BOOL(hide_on_close) << ')';
   // set_close
   // editable_enters
   // set_default
   // set_parent ?
}

Subwidget Gnome_Dialog::IsSubwidget(const Widget &w,const Widget &ch) const
{  if (ch.ChildName()=="GnomeDialog:vbox") return is_Subwidget;
   if (ch.ChildName()=="GnomeDialog:action_area") return is_Subwidget_all;
   if (ch.ChildName()!="") {  std::cerr << "Child name '" << ch.ChildName() << "'\n"; }
   return not_Subwidget;
}

const std::string Gnome_Dialog::InternalInstance(const Widget &parent,const Widget &ch) const
{  if (ch.ChildName()=="GnomeDialog:vbox") return "get_vbox()->";
   if (ch.ChildName()=="GnomeDialog:action_area") return ""; // no accessor, yet

   if (ch.Class()!="GtkButton") return Parent::InternalInstance(parent,ch);
   if (parent.begin()==parent.end()) return Parent::InternalInstance(parent,ch);
   const Widget w2(*(parent.begin()));
   assert(w2.ChildName().find(":vbox")!=std::string::npos);
   // perhaps an additional tag would be the best to speed this up 
   // this looks up the button's index
   for (Widget::const_iterator i=w2.begin();i!=w2.end();++i)
   {  if ((*i).ChildName().find(":action_area")!=std::string::npos)
      {  const Widget w3(*i);
         int index(0);
         for (Widget::const_iterator j=w3.begin();j!=w3.end();++j)
         {  if (ch==*j) 
            {  char buf[50];
               snprintf(buf,sizeof buf,"get_button(%d)->",index);
               return buf;
            }
            ++index;
         }
      }
   }
   return Parent::InternalInstance(parent,ch);
}

void Gnome_Dialog::ConstructionArgs(const Widget &w, CxxFile &f) const
{  const std::string title(w.getString("title"));
   // const Gtk::SArray &buttons ...
   f.FunctionArg(); 
   if (title.size()) 
   {  f << Configuration.Translatable(title) << ", std::vector<std::string>()";
   }
}

bool Gnome_Dialog::NeedExplicitCtor(const Widget &w) const
{ return true; }

void Gnome_Dialog::GCDefinition(const Widget &w, CxxFile &f) const
{  Parent::GCDefinition(w,f);
#warning here is an interesting variant - but yet unused
// perhaps we can allocate the buttons statically
#if 0
   const std::string name(w.Name());
   f.Declaration() << "const const char * const[]";
   f.Assignment().StartBlock();
   f << bla bla bla ...
#endif   
}

void Gnome_Dialog::GCInclude(const Widget &w, CxxFile &f) const
{  Parent::GCInclude(w,f);
   f.Include("vector");
}
