// $Id: gnome_druidpage.cc,v 1.3 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 2001 Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <cstdio>
#include "gnome_druidpage.hh"

static Gnome_DruidPage Gnome_DruidPage(false);

const std::string Gnome_DruidPage::TypeName(const Widget &w) const
{  return GnomePrefix()+"DruidPage";
}

const std::string Gnome_DruidPage::IncludeName(const Widget &w) const
{  return "gnome--/druid-page.h";
}

Gnome_DruidPage::Gnome_DruidPage(bool base_class_init)
{  if (!base_class_init) Writer["GnomeDruidPage"]=this;
}

void Gnome_DruidPage::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg();
}

void Gnome_DruidPage::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   const std::string title_color(w.getString("title_color"));
   const std::string background_color(w.getString("background_color"));
   const std::string logo_background_color(w.getString("logo_background_color"));
   const std::string logo_image(w.getString("logo_image"));
   const std::string title(w.getString("title"));
   
   if (title_color.size())
   	f.Statement() << instance << "set_title_color(" << PushColor(title_color) << ')';
   if (background_color.size())
   	f.Statement() << instance << "set_bg_color(" << PushColor(background_color) << ')';
   if (logo_background_color.size())
   	f.Statement() << instance << "set_logo_bg_color(" << PushColor(logo_background_color) << ')';
   if (logo_image.size())
   	f.Statement() << instance << "set_logo(Gdk_Imlib::Image(" << Configuration.CString_WithQuotes(logo_image) << "))";
   if (title.size())
   	f.Statement() << instance << "set_title(" << Configuration.Translatable(title) << ')';
}

#warning signals are missing: next, prepare, back, finish, cancel

//#include <cstdio>

const std::string Gnome_DruidPage::PushColor(const std::string &s)
{  int r=0,g=0,b=0;
   sscanf(s.c_str(),"%d,%d,%d",&r,&g,&b);
   char buf[60];
   snprintf(buf,sizeof buf,"#%02x%02x%02x",r&0xff,g&0xff,b&0xff);
   return std::string("Gdk_Color(\"")+buf+"\")";
}
