// $Id: gnome_pixmap.cc,v 1.2 2001/10/11 14:07:24 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 2001 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "widget.hh"

class Gnome_Pixmap : public Gtk_Widget
{public:
	typedef Gtk_Widget Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gnome_Pixmap();
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return w.hasTag("filename"); }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const;
};

static Gnome_Pixmap Gnome_Pixmap;

const std::string Gnome_Pixmap::TypeName(const Widget &w) const
{  return GnomePrefix()+"Pixmap";
}

const std::string Gnome_Pixmap::IncludeName(const Widget &w) const
{  return "gnome--/pixmap.h";
}

Gnome_Pixmap::Gnome_Pixmap()
{  Writer["GnomePixmap"]=this;
}

void Gnome_Pixmap::ConstructionArgs(Widget const &w, CxxFile &f) const
{  const std::string filename(w.getString("filename"));
   f.FunctionArg(); 
   f << Configuration.CString_WithQuotes(filename);
   // width, height
   // xpm ???
}
