/* $Id: rgb.h,v 1.3 2000/01/13 20:11:22 mac Exp $ */

/*
 * glbiff -- A Mesa/OpenGL-based `xbiff' substitute
 * Copyright (C) 2000  Maciej Kalisiak
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __RGB_H__
#define __RGB_H__

class Rgb {
 public:
  double r;
  double g;
  double b;

 public:
  Rgb( double x, double y, double z ): r(x), g(y), b(z) {}
};

class Rgb_kf {
 public:
  double s;	// parameter; s=0 -> sunrise ; s=1 -> sunset
  Rgb rgb;

 public:
  Rgb_kf( double w, double x, double y, double z ): s(w), rgb(x,y,z) {}
  Rgb_kf( void ): s(0), rgb(0,0,0) {}

  bool operator<( const Rgb_kf& kf ) const {
    return s < kf.s;
  }
};

/* Rgb_kf sky_keyframes[] = { */
/*   {0, 40/255.0, 40/255.0, 40/255.0 }, */
/*   {0.2, 126/255.0, 193/255.0, 226/255.0 }, */
/*   {0.5, 130/255.0, 225/255.0, 255/255.0 }, */
/*   {0.9, 140/255.0, 150/255.0, 170/255.0 }, */
/*   {0.97, 193/255.0, 121/255.0, 37/255.0 }, */
/*   {1, 40/255.0, 40/255.0, 40/255.0 }, */
/* }; */
  
  
  
#endif /* __RGB_H__ */
