/*  Glimmer - mdi-routines.h
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <libgnomevfs/gnome-vfs-types.h>
#include <libgnomevfs/gnome-vfs-uri.h>

#ifndef MDI_ROUTINES_H
#define MDI_ROUTINES_H

#ifdef __cplusplus
extern "C" {
#endif

#include "declarations.h"
#include "widgets/gdsfile.h"

GdsFile *construct_file(GnomeVFSURI *uri);
void file_pos_changed(GtkWidget *widget, gint pos, gpointer data);
void gds_file_focus_with_raise(GtkWidget *widget, GdsFile *gds_file);
void set_length_depends(gint length);
void init_label_styles(GtkStyle *style);
void destroy_label_styles(void);
void set_label_colors(GdsFile *file);

extern GtkStyle *normal_style;
extern GtkStyle *changed_style;

#ifdef __cplusplus
}
#endif

#endif
