/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * See the COPYING file for license information.
 *
 * Guillaume Chazarain <booh@altern.org>
 */

/*****************************
 * The help and about boxes. *
 *****************************/

#include "gliv.h"
#include "help.h"
#include "about.h"

extern rt_struct *rt;

static GtkWindow *label_win;

static gchar *get_help_text(void)
{
    gchar *help;

#ifdef ENABLE_NLS
    const gchar *help_box = N_("__Help box__");
    gchar *ptr;

    help = _(help_box);

    if (g_str_equal(help, help_box) == TRUE)
        /* No translation found. */
        return g_strdup(HELP_TEXT);
    else {
        /* Translation found. '\\' has to be replaced with '\n'. */
        help = g_strdup(help);
        for (ptr = help; *ptr != '\0'; ptr++) {
            if (*ptr == '\\')
                *ptr = '\n';
        }

        ptr = help;
        help = locale_to_utf8(help);
        if (help != ptr)
            g_free(ptr);
        return g_strdup(help);
    }
#else
    return g_strdup(HELP_TEXT);
#endif
}

static void show_help(void)
{
    GtkLabel *label;
    PangoFontDescription *font;
    gchar *help_text;

    help_text = get_help_text();
    label = GTK_LABEL(gtk_label_new(help_text));
    g_free(help_text);

    gtk_label_set_justify(label, GTK_JUSTIFY_LEFT);

    /* We use a fixed font to keep the alignment as in the README file. */
    font = pango_font_description_from_string(FONT);
    gtk_widget_modify_font(GTK_WIDGET(label), font);

    label_win = GTK_WINDOW(gtk_window_new(GTK_WINDOW_TOPLEVEL));

    gtk_container_set_border_width(GTK_CONTAINER(label_win), 10);

    g_signal_connect_swapped(label_win, "delete_event",
                             G_CALLBACK(toggle_help), NULL);

    gtk_container_add(GTK_CONTAINER(label_win), GTK_WIDGET(label));

    show_dialog(GTK_WIDGET(label_win), _("GLiv help"), FALSE);
}

gboolean toggle_help(void)
{
    rt->help ^= TRUE;

    if (rt->help == TRUE)
        show_help();
    else
        gtk_widget_destroy(GTK_WIDGET(label_win));

    return TRUE;
}

void show_about_box(void)
{
    static GtkWindow *about_win = NULL;
    GtkLabel *about;
    gchar *about_text;

    if (about_win != NULL && GTK_IS_WINDOW(about_win) == TRUE)
        /* About box currently displayed. */
        gtk_widget_destroy(GTK_WIDGET(about_win));

    about_text = g_strconcat(_(ABOUT_VERSION), " ", VERSION, "\n",
                             "Guillaume Chazarain <booh@altern.org>\n",
                             _(ABOUT_HELP), "\n", "\n", _(ABOUT_URL), "\n",
                             "\n", _(ABOUT_CLICK_HIDE), NULL);

    about = GTK_LABEL(gtk_label_new(locale_to_utf8(about_text)));
    g_free(about_text);

    about_win = GTK_WINDOW(gtk_window_new(GTK_WINDOW_TOPLEVEL));

    gtk_container_add(GTK_CONTAINER(about_win), GTK_WIDGET(about));
    gtk_container_set_border_width(GTK_CONTAINER(about_win), 10);

    gtk_widget_set_events(GTK_WIDGET(about_win), GDK_BUTTON_PRESS_MASK);

    g_signal_connect(about_win, "button_press_event",
                     G_CALLBACK(gtk_widget_destroy), NULL);

    show_dialog(GTK_WIDGET(about_win), _("GLiv about box"), FALSE);
}
