/*
 *  Copyright (C) 2005  Maarten de Boer <maarten@resorama.com>
 * 
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 *  02110-1301, USA.
 * 
 */

#ifndef __RGBA__
#define __RGBA__

class Data2D
{
public:
   int Width() const { return width; }
   int Height() const { return height; }
   unsigned char* Data() const { return data; }
protected:
   int width,height,elemsize;
   unsigned char* data;
   Data2D(int e)
         :width(0),height(0),elemsize(e),data(0)
   {
   }
   ~Data2D()
   {
      if (data) delete [] data;
   }
   Data2D(int w,int h,int e)
         :width(0),height(0),elemsize(e),data(0)
   {

      Alloc(w,h);
   }
public:
   void Alloc(int w,int h)
   {
      if (w==width && h==height) return;
      if (data) throw "Data2D already allocated with different size";
      width = w;
      height = h;
      data = new unsigned char[width*height*elemsize];
   }
};

class RGB:public Data2D
{
public:
   RGB():Data2D(3) { };
   RGB(int w,int h):Data2D(w,h,3) { };
};

class RGBA:public Data2D
{
public:
   RGBA():Data2D(4) { };
   RGBA(int w,int h):Data2D(w,h,4) { };

   void Paste(const RGBA& src,int x,int y)
   {
      unsigned char* ptrB = src.data;

      for (int j = 0; j < src.height; j++)
      {
         unsigned char* ptrA = data + (y*width+x)*4;
         for (int i = 0;i < src.width; i++)
         {
            *ptrA++ = *ptrB++;
            *ptrA++ = *ptrB++;
            *ptrA++ = *ptrB++;
            *ptrA++ = *ptrB++;
         }
         y++;
      }
   }
   void Paste(const RGB& src,int x,int y)
   {
      unsigned char* ptrB = src.Data();

      for (int j = 0; j < src.Height(); j++)
      {
         unsigned char* ptrA = data + (y*width+x)*4;
         for (int i = 0;i < src.Width(); i++)
         {
            *ptrA++ = *ptrB++;
            *ptrA++ = *ptrB++;
            *ptrA++ = *ptrB++;
            *ptrA++ = 256;
         }
         y++;
      }
   }
};

#endif


