/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#ifndef __GTK_ROOT_POINT_BUTTON_H__
#define __GTK_ROOT_POINT_BUTTON_H__


#include <gtk/gtkbutton.h>


G_BEGIN_DECLS



#define GTK_TYPE_ROOT_POINT_BUTTON		   (gtk_root_point_button_get_type ())
#define GTK_ROOT_POINT_BUTTON(obj)		   (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_ROOT_POINT_BUTTON, GtkRootPointButton))
#define GTK_ROOT_POINT_BUTTON_CLASS(klass)	   (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_ROOT_POINT_BUTTON, GtkRootPointButtonClass))
#define GTK_IS_ROOT_POINT_BUTTON(obj)		   (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_ROOT_POINT_BUTTON))
#define GTK_IS_ROOT_POINT_BUTTON_CLASS(klass)	   (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_ROOT_POINT_BUTTON))
#define GTK_ROOT_POINT_BUTTON_GET_CLASS(obj)	   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_ROOT_POINT_BUTTON, GtkRootPointButtonClass))


typedef struct _GtkRootPointButton	 GtkRootPointButton;
typedef struct _GtkRootPointButtonClass	 GtkRootPointButtonClass;

struct _GtkRootPointButton
{
  GtkButton button;

  gboolean   in_grab;
  GdkCursor *grab_cursor;
};

struct _GtkRootPointButtonClass
{
  GtkButtonClass parent_class;

  void (* pointing_begin) (GtkRootPointButton *root_point_button);
  void (* pointing_end)	  (GtkRootPointButton *root_point_button);
  void (* pointed)	  (GtkRootPointButton *root_point_button);
};


GType	   gtk_root_point_button_get_type	(void) G_GNUC_CONST;

GtkWidget* gtk_root_point_button_new		(void);
GtkWidget* gtk_root_point_button_new_with_label (gchar *label);



G_END_DECLS


#endif /* __GTK_ROOT_POINT_BUTTON_H__ */
