/*
    Glurp - A GTK+ client for Music Player Daemon
    Copyright (C) 2004, 2005 Andrej Kacian

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    http://musicpd.org/glurp.shtml

*/

#ifndef __COMM_H
#define __COMM_H

gint glurp_connect();
void glurp_disconnect();
mpd_Status *get_status(gboolean standalone);
void update_playlist();
void clear_playlist();
void get_playlist_list();
void clear_playlist_list();
void load_playlist(gchar *name);
GlurpSong *glurp_get_nth_song(gint n);
gboolean check_mpd_error();
void glurp_add_add_dir(gchar *path, GtkTreePath *gpath);
void glurp_add_search_result_dir(const gchar *what, int type, GtkTreePath *gpath);
gboolean glurp_process_plchanges(mpd_Status *status);
void glurp_update_song(mpd_Song *song);
void glurp_trim_playlist_end(gint last);

enum {
    GLURP_CONN_STATE_DISCONNECTED,
    GLURP_CONN_STATE_CONNECTING,
    GLURP_CONN_STATE_CONNECTED,
    GLURP_CONN_STATE_DISCONNECTING
};

#define DISCONNECTED	(glurp->conn_state == GLURP_CONN_STATE_DISCONNECTED)
#define CONNECTING	(glurp->conn_state == GLURP_CONN_STATE_CONNECTING)
#define CONNECTED	(glurp->conn_state == GLURP_CONN_STATE_CONNECTED)
#define DISCONNECTING	(glurp->conn_state == GLURP_CONN_STATE_DISCONNECTING)

#endif /* __COMM_H */
